package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.yeejoin.amos.boot.module.hygf.api.dto.ExceptionLogDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.ConstructionRecords;
import com.yeejoin.amos.boot.module.hygf.api.entity.ExceptionLog;
import com.yeejoin.amos.boot.module.hygf.api.mapper.ExceptionLogMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IExceptionLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Enumeration;


@Service
@Slf4j
public class ExceptionLogServiceImpl extends BaseService<ExceptionLogDto, ExceptionLog, ExceptionLogMapper>
        implements IExceptionLogService {


    @Override
    public void addLog(String businessType, String reqBody, Exception exception, HttpServletRequest request) {
        try {
            ExceptionLog exceptionLog = new ExceptionLog();
            exceptionLog.setRecDate(new Date());
            log.error(exception.getMessage(),exception);
            exceptionLog.setErrorLog(getStackTraceAsString(exception));
            exceptionLog.setRequest(getRequestInfo(request));
            exceptionLog.setBusinessType(businessType);
            exceptionLog.setReqBody(reqBody);
            this.save(exceptionLog);
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }
    }

    // 将异常堆栈转换为字符串
    private static String getStackTraceAsString(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e).append("\n");
        for (StackTraceElement element : e.getStackTrace()) {
            sb.append(element.toString()).append("\n");
        }
        return sb.toString();
    }

    private   String getRequestInfo(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();

        // 拼接请求方法 (GET, POST等)
        sb.append("Method: ").append(request.getMethod()).append("\n");

        // 拼接请求URL
        sb.append("Request URL: ").append(request.getRequestURL()).append("\n");

        // 拼接查询参数
        sb.append("Query Parameters: \n");
        Enumeration<String> paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = paramNames.nextElement();
            sb.append(paramName).append("=").append(request.getParameter(paramName)).append("\n");
        }

        // 拼接请求头
        sb.append("Headers: \n");
        Enumeration<String> headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            sb.append(headerName).append(": ").append(request.getHeader(headerName)).append("\n");
        }

        // 拼接客户端IP地址
        sb.append("Client IP: ").append(request.getRemoteAddr()).append("\n");

        return sb.toString();
    }

    public <T>ResponseModel<T> errorResponseModel(T t,HttpServletRequest request,Exception e){
        ResponseModel<T> response = new ResponseModel<>();
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        response.setTraceId(RequestContext.getTraceId());
        response.setPath(request.getServletPath());
        response.setDevMessage(e.getMessage());
        response.setMessage(e.getMessage());
        return response;
    }
}