package com.yeejoin.amos.boot.module.jxiop.api.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

@Component
public class AsyncConfig {

    @Bean("async")
    public Executor asyncScheduledTask(){
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(50);
        executor.setCorePoolSize(20);
        executor.setQueueCapacity(50);
        executor.setThreadNamePrefix("async-thread-");
        executor.setKeepAliveSeconds(60);
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy(){});
        executor.initialize();
        return executor;
    }




}
