package com.yeejoin.amos.boot.module.jxiop.api.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 户用光伏合同表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("household_pv_lease")
public class HouseholdPvLease extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 户用光伏id
     */
	@TableField("household_pv_id")
    private Long householdPvId;

    /**
     * 安装地址
     */
	@TableField(value = "install_address", updateStrategy = FieldStrategy.IGNORED)
    private String installAddress;

    /**
     * 安装日期
     */
	@TableField(value = "install_date", updateStrategy = FieldStrategy.IGNORED)
    private Date installDate;

    /**
     * 预计功率(w)
     */
	@TableField(value = "estimated_power", updateStrategy = FieldStrategy.IGNORED)
    private String estimatedPower;

    /**
     * 组件单片功率(w)
     */
	@TableField(value = "monolithic_power", updateStrategy = FieldStrategy.IGNORED)
    private Integer monolithicPower;

    /**
     * 共计安装数量(块)
     */
	@TableField(value = "install_count", updateStrategy = FieldStrategy.IGNORED)
    private Integer installCount;

    /**
     * 实际容量(w)
     */
	@TableField(value = "actual_capacity", updateStrategy = FieldStrategy.IGNORED)
    private Integer actualCapacity;

    /**
     * 电站类型
     */
	@TableField("station_type")
    private String stationType;

    /**
     * 组件规格
     */
	@TableField("module_type")
    private String moduleType;

    /**
     * 创建时间
     */
	@TableField("create_time")
    private Date createTime;


    /**
     * 逆变器序列号
     */
    @TableField(value = "inverter_serial_number", updateStrategy = FieldStrategy.IGNORED)
    private String inverterSerialNumber;

}
