package com.yeejoin.amos.boot.module.jxiop.biz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.RegionNationWideDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ResultsData;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.SocialContributionDto;

import java.util.HashMap;
import java.util.List;

public interface MonitorService {
    /**
     * @description 获取运行监盘全国屏总数数据
     */
    public void getTotalData();

    /**
     * @description 根据省份名称、type字段等判断动态获取地图图钉数据
     * @param provinceName 省份名称
     * @param type gis、station
     * @return 地图图钉数据列表
     */
    public List<RegionNationWideDto> getNationWideInfo(String provinceName, String type);

    /**
     * @description 根据省份名称获取动态表格数据
     * @param current 当前页
     * @param size 分页大小
     * @param provinceName 省份名称
     * @return 动态表格数据
     */
    public ResultsData getCompletionOfPowerIndicatorsByProvinceName(int current, int size, String provinceName);

    /**
     * @description  根据地区名称获取有功功率数据
     * @param areaName
     * @return 有功功率
     */
    public HashMap<String, String> getActivePowerByAreaName(String areaName);

    /**
     * @description  根据地区名称获取发电数据
     * @param areaName
     * @return
     */
    public Page<HashMap<String, String>> getDetailsOnPowergeneration(String areaName);

    /**
     * @description  根据地区名称获取社会贡献数据
     * @param areaName
     * @param stationId
     * @return
     */
    public Page<SocialContributionDto> getSocialContributionDtoList(String areaName, String stationId) ;

    /**
     * @description  根据地区名称获取发电量完成度排名前五的数据
     * @param areaName
     * @return
     */

     Page<HashMap<String, String>> getPowerGenerationTrendsOfCompletionTopFive(String areaName);
     Page<HashMap<String, String>> getPowerGenerationTrendsOfCompletionTopThree(String tabValue, String areaName);
}
