package com.yeejoin.amos.api.openapi.face.service;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.api.openapi.enums.JgFileAttributeEnum;
import com.yeejoin.amos.api.openapi.enums.JgFileObjectEnum;
import com.yeejoin.amos.api.openapi.face.model.EnterpriseInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.EnterpriseInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.EnterpriseInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.JgFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 企业数据信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class EnterpriseInfoService extends AppBaseService<EnterpriseInfoModel, EnterpriseInfo, EnterpriseInfoMapper> {

    @Autowired
    private JgFileService fileService;

    /**
     *
     * 新增企业数据信息
     *
     * @param model 企业数据信息model集合
     * @return  成功返回“ok” 失败返回“Access_token无效”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveEnterpriseInfo(List<EnterpriseInfoModel> model) {
        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("企业数据信息为空.");
        }

        List<JgFile> fileList = new ArrayList<>();
        List<JgFile> businessLicenseList;

        for (EnterpriseInfoModel models : model) {
            checkModel(models);
            models.setRecDate(new Date());
            models.setAppId(getAppId());

            EnterpriseInfoModel enterpriseInfoModel = this.createWithModel(models);

            businessLicenseList = JSONObject.parseArray(JSONObject.toJSONString(models.getBusinessLicense()), JgFile.class);

            for (JgFile files : businessLicenseList) {
                JgFile file = new JgFile();
                file.setSequenceCode(models.getUseUnitCode());
                file.setAppId(getAppId());
                file.setObjectType(JgFileObjectEnum.ENTERPRISE_INFO.getObject());
                file.setAttributeType(JgFileAttributeEnum.BUSINESS_LICENSE.getAttribute());
                file.setSyncDate(models.getSyncDate());
                file.setFileUrl(files.getFileUrl());
                file.setFileName(files.getFileName());
                file.setRecDate(new Date());
                file.setSquNbr(enterpriseInfoModel.getSequenceNbr());
                fileList.add(file);
            }
        }
        fileService.saveBatch(fileList);
        return "OK";

    }

    /**
     * 信息校验
     *
     * @param models
     */
    private static void checkModel(EnterpriseInfoModel models) {
        if(ValidationUtil.isEmpty(models.getUseUnitCode())) {
            throw new BadRequest("使用单位唯一标识不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"监管系统唯一编码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getUseCode())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"使用单位代码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getUseUnit())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"使用单位名称不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getProvince())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"单位所在省份名称不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getCity())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"单位所在城市名称不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getDistrict())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"单位所在区县名称不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getStreet())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"单位所在街道名称不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getCommunity())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"单位所在社区名称不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getAddress())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"单位详细地址不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getLegalPerson())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"使用单位法人不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getUseContact())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"使用单位联系人不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getContactPhone())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"联系人联系电话不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSafetyOne())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"安全管理人员1姓名不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSafetyOnePhone())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"安全管理人员1联系电话不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSyncDate())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"同步时间不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSyncState())) {
            throw new BadRequest("使用单位标识码为："+models.getUseUnitCode()+"的企业，"+"同步状态不能为空！");
        }
    }
}
