package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 消防车辆信息
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("ast_fire_vehicle")
public class FireVehicle extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 消防资产id
     */
    @TableField("mrid")
    private String mrid;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 名称
     */
    @TableField("name")
    private String name;

    /**
     * 车辆号
     */
    @TableField("number")
    private String number;

    /**
     * 车辆类别名称
     */
    @TableField("type")
    private String type;

    /**
     * 规格型号
     */
    @TableField("standard")
    private String standard;

    /**
     * 厂商
     */
    @TableField("manufacturer")
    private String manufacturer;

    /**
     * 品牌
     */
    @TableField("brand")
    private String brand;

    /**
     * 国别
     */
    @TableField("country")
    private String country;

    /**
     * 底盘国别
     */
    @TableField("chassis_country")
    private String chassisCountry;

    /**
     * 底盘品牌
     */
    @TableField("chassis_brand")
    private String chassisBrand;

    /**
     * 物联编码
     */
    @TableField("iot_code")
    private String iotCode;

    /**
     * 车辆状态
     */
    @TableField("state")
    private String state;

    /**
     * 启动状态
     */
    @TableField("start_state")
    private String startState;

    /**
     * 最近启动时间
     */
    @TableField("last_start_date")
    private Date lastStartDate;

    /**
     * 维保单位
     */
    @TableField("maintenance_unit")
    private String maintenanceUnit;

    /**
     * 首次维保日期
     */
    @TableField("firstmaintenance_date")
    private Date firstmaintenanceDate;

    /**
     * 维保频率
     */
    @TableField("maintenance_frequency")
    private String maintenanceFrequency;

    /**
     * 维保电话
     */
    @TableField("maintenance_phone")
    private String maintenancePhone;

    /**
     * 修改时间
     */
    @TableField("updatedate")
    private Date updatedate;

    /**
     * 经度
     */
    @TableField("lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField("lat")
    private String lat;

}
