package com.yeejoin.amos.boot.module.ccs.api.service;


import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * 消防设备资产接口类
 *
 * @author system_generator
 * @date 2021-11-09
 */
public interface IFireEquipmentService {

    /**
     * 物联接入汇总
     *
     * @param stationCode 换流站编号
     * @return Map<String, Object>
     */
    Map<String, Object> selectForMonitorCount(String stationCode) throws ParseException;

    /**
     * 站端物联设备
     *
     * @param stationCode 换流站code
     * @param stationName
     * @return List<FireStationInfoDto>
     */
    List<Map<String, Object>> stationEquipmentInfo(String stationCode, String stationName);

    /**
     * 故障设备汇总
     *
     * @param top 上限数量
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> faultEquipTopCount(Long top);
}
