package com.yeejoin.equipmanage.common.entity.publics;

import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.List;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.entity.publics
 * @ClassName: BaseTreeNode
 * @Author: Jianqiang Gao
 * @Description: BaseTreeNode
 * @Date: 2021/6/1 14:58
 * @Version: 1.0
 */
//@Data
public class BaseTreeNode {
    /**
     * 子Id
     */
    private String id;
    /**
     * 父ID
     */
    private String parentId;

    private List<BaseTreeNode> children;

    private String companyId;

    private String ownerUnitId;

    private Integer type;



    public BaseTreeNode() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyId() {
        return companyId;
    }
    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
    public void setOwnerUnitId(String ownerUnitId) {
        this.ownerUnitId = ownerUnitId;
    }
    public String getOwnerUnitId() {
        return ownerUnitId;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public Integer getType() {
        return type;
    }
    public List<BaseTreeNode> getChildren() {
        if (this.children == null) {
            return Lists.newArrayList();
        }
        return children;
    }

    public void setChildren(List<BaseTreeNode> children) {
        this.children = children;
    }

    public void addChild(BaseTreeNode baseTreeNode) {
        if (this.children == null) {
            this.setChildren(new ArrayList());
        }
        this.getChildren().add(baseTreeNode);
    }
}