package com.yeejoin.equipmanage.common.enums;

import java.util.List;

import com.google.common.collect.Lists;

/**
 * @author DELL
 */
public enum CarStatusEnum {

	// 在位状态下可变为 执勤、维修、退役、报废
	ZW("1","在位", Lists.newArrayList("2", "3", "6", "7")),
	// 执勤状态下可变为 在位
	ZQ("2","执勤", Lists.newArrayList("1")),
	// 维修状态下可变为 在位、退役、报废
	WX("3","维修", Lists.newArrayList("1", "6", "7")),
	// 退役状态下可变为 报废
	TY("6","退役", Lists.newArrayList("7")),
	BF("7","报废", Lists.newArrayList());
	
	
	private String name;
	
	private String code;

	/**
	 * 当前状态下可进行操作code
	 */
	private List<String> allowedOp;
	
	private CarStatusEnum(String code,String name, List<String> allowedOp){
		this.code=code;
		this.name=name;
		this.allowedOp = allowedOp;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public String getCode() {
		return code;
	}
	
	public void setCode(String code) {
		this.code = code;
	}

	public List<String> getAllowedOp() {
		return allowedOp;
	}

	public void setAllowedOp(List<String> allowedOp) {
		this.allowedOp = allowedOp;
	}

	public static CarStatusEnum getEnum(String code) {
		for (CarStatusEnum status: CarStatusEnum.values()) {
			if (status.getCode().equals(code)) {
				return status;
			}
		}
		return null;
	}
	public static CarStatusEnum getEnumByName(String name) {
		for (CarStatusEnum status: CarStatusEnum.values()) {
			if (status.getName().equals(name)) {
				return status;
			}
		}
		return null;
	}
	
	public static String getNameByCode(String code) {
		for (CarStatusEnum status: CarStatusEnum.values()) {
			if (status.getCode().equals(code)) {
				return status.getName();
			}
		}
		return "在位";
	}
}
