package com.yeejoin.amos.latentdanger.common.enums;

/**
 * 隐患来源类型枚举
 *
 * @author DELL
 */
public enum LatentDangerTypeEnum {

    /**
     * 无码检查
     */
    无码检查("无码检查", "1"),
    /**
     * 计划检查
     */
    计划检查("计划检查", "2"),
    /**
     * 无计划检查
     */
    无计划检查("无计划检查", "3"),
    /**
     * 随手拍
     */
    随手拍("随手拍", "4");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    LatentDangerTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static String getEnumName(String code) {
        String name = "";
        for(LatentDangerTypeEnum type: LatentDangerTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                name = type.getName();
                break;
            }
        }
        return name;
    }

    public static LatentDangerTypeEnum getByCode(String code) {
        for (LatentDangerTypeEnum l : LatentDangerTypeEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }
}
