package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.DynamicFormGroup;
import com.yeejoin.equipmanage.common.entity.DynamicFormInstance;
import com.yeejoin.equipmanage.common.entity.FireFightingSystemEntity;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import com.yeejoin.equipmanage.common.exception.BaseException;
import com.yeejoin.equipmanage.mapper.EqDynamicFormGroupMapper;
import com.yeejoin.equipmanage.service.IEqDynamicFormGroupService;
import com.yeejoin.equipmanage.service.IEqDynamicFormInstanceService;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 动态表单树形分组表 服务实现类
 *
 * @author duanwei
 * @date 2021-03-08
 */
@Service
public class EqEqDynamicFormGroupServiceImpl extends ServiceImpl<EqDynamicFormGroupMapper, DynamicFormGroup> implements IEqDynamicFormGroupService {

    @Autowired
    IEqDynamicFormInstanceService iEqDynamicFormInstanceService;

    @Autowired
    IEqDynamicFormGroupService iEqDynamicFormGroupService;
    
    
    @Autowired
    IFireFightingSystemService iFireFightingSystemService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean checkAndRemoveById(List<Long> ids) {
        boolean  re = false;
        //1.获取子的分组信息，英文字典在子分组存放
        for (Long id:ids) {
            List<DynamicFormGroup> allGroup = this.findChildren(id);
            List<Long> cids = allGroup.stream().map(BaseEntity::getId).collect(Collectors.toList());
            int useNum = 0;
            //2.校验是否在使用
            if (!CollectionUtils.isEmpty(cids)) {
                useNum = iEqDynamicFormInstanceService.count(new LambdaQueryWrapper<DynamicFormInstance>().in(DynamicFormInstance::getGroupId, cids));
            }
            useNum +=iFireFightingSystemService.count(new QueryWrapper<FireFightingSystemEntity>().eq("form_group_id",id));
            if (useNum > 0) {
            throw new BaseException("在使用中不能删除");
            }
            //删除子表
            if (cids != null && cids.size() > 0) {
                iEqDynamicFormGroupService.removeByIds(cids);
            }
            //删除主表
            re = this.removeById(id);
        }
        return re;
    }

    @Override
    public void saveAndCheck(DynamicFormGroup dynamicFormGroup) {
        List<DynamicFormGroup> formGroups = this.list(new LambdaQueryWrapper<DynamicFormGroup>()
                .eq(DynamicFormGroup::getGroupType,dynamicFormGroup.getGroupType())
                .eq(DynamicFormGroup::getGroupCode,dynamicFormGroup.getGroupCode()));
        if(!formGroups.isEmpty()){
            throw new BaseException("该类型系统已经创建");
        }
        this.saveOrUpdate(dynamicFormGroup);
    }

    private List<DynamicFormGroup> findChildren(Long id) {
        List<DynamicFormGroup> dynamicFormGroups = this.list(new LambdaQueryWrapper<DynamicFormGroup>().eq(DynamicFormGroup::getParentId, id));
        List<DynamicFormGroup> list = new ArrayList<>(dynamicFormGroups);
        for (DynamicFormGroup group : dynamicFormGroups) {
            List<DynamicFormGroup> children = this.list(new LambdaQueryWrapper<DynamicFormGroup>().eq(DynamicFormGroup::getParentId, group.getId()));
            list.addAll(children);
            list.addAll(this.findChildren(group.getId()));
        }
        return list;
    }
}
