package com.yeejoin.amos.fas.business.dao.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.fas.dao.entity.AccidentType;

@Repository("iAccidentTypeDao")
public interface IAccidentTypeDao extends BaseDao<AccidentType, Long> {
    
	@Modifying
	@Transactional
	@Query(value="delete from f_accident_type where id in (?1)", nativeQuery = true)
	void deleteAllByIds(Long[] param);
	
	
	@Modifying
	@Query(value="SELECT a.id,a.name,CONCAT(fem.influence,'-',fem.`describe`) AS influence,fem.coefficient AS severity,a.remark"
		+" FROM f_accident_type a"
		+" LEFT JOIN f_evaluation_model fem ON fem.id = a.evaluation_sid"
		+" WHERE a.org_code = ?1", nativeQuery = true)
	List<HashMap<String,Object>> findAccidentTypeListByOrgCode(String orgCode);
}
