package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.hygf.api.dto.UnitRegisterDto;
import com.yeejoin.amos.boot.module.hygf.api.hwsms.SendSmsCode;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import io.swagger.annotations.ApiParam;
import org.apache.poi.util.ArrayUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.*;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.UnitInfoServiceImpl;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.UnitInfoDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 经销商人员信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@RestController
@Api(tags = "经销商单位信息Api")
@RequestMapping(value = "/unit-info")
public class UnitInfoController extends BaseController {

    @Autowired
    UnitInfoServiceImpl unitInfoServiceImpl;

	@Autowired
	AmosRequestContext requestContext;

	@Autowired
	RedisUtils redisUtil;

	@Value("${hygf.sms.tempCode}")
	private String smsTempCode;

	@Autowired
	SendSmsCode sendSmsCode;

	public static final String HYGF_USER_TEL = "hygf_tel_";

	/**
	 * 验证码过期时间
	 */
	private long time = 180L;

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新经销商人员信息", notes = "根据sequenceNbr更新经销商人员信息")
	public ResponseModel<UnitInfoDto> updateBySequenceNbrUnitInfo(@RequestBody UnitInfoDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(unitInfoServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除经销商人员信息", notes = "根据sequenceNbr删除经销商人员信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(unitInfoServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个经销商人员信息",  notes = "根据sequenceNbr查询单个经销商人员信息")
	public ResponseModel<UnitInfoDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(unitInfoServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "经销商人员信息分页查询",  notes = "经销商人员信息分页查询")
	public ResponseModel<Page<UnitInfoDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<UnitInfoDto> page = new Page<UnitInfoDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(unitInfoServiceImpl.queryForUnitInfoPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "经销商人员信息列表全部数据查询",   notes = "经销商人员信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<UnitInfoDto>> selectForList() {
	    return ResponseHelper.buildResponse(unitInfoServiceImpl.queryForUnitInfoList());
	}


	/**
	 * 管理员身份证图片上传 无token
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/uploadFile")
	@ApiOperation(httpMethod = "POST", value = "管理员身份证图片上传 无token", notes = "管理员身份证图片上传 无token")
	public ResponseModel<String> uploadFile(@ApiParam(value = "文件", required = true)@RequestParam MultipartFile file) {
		if (ValidationUtil.isEmpty(file)){
			throw new BadRequest("参数校验失败.");
		}
		RequestContext.setAppKey("AMOS_STUDIO");
		RequestContext.setProduct("AMOS_STUDIO_WEB");
		RequestContext.setToken(requestContext.getToken());
		FeignClientResult<Map<String, String>> date = Systemctl.fileStorageClient.updateCommonFile(file);
		String urlString="";
		if (date != null) {
			Map<String, String> map = date.getResult();
			Iterator<String> it = map.keySet().iterator();
			while (it.hasNext()) {
				urlString=it.next();
			}
		}
		return ResponseHelper.buildResponse(urlString);
	}

	/**
	 * 获取组织机构树
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/region/tree")
	@ApiOperation(httpMethod = "GET", value = "获取组织机构树", notes = "获取组织机构树")
	public ResponseModel<Collection<RegionModel>> getRegionTree() {
		RequestContext.setAppKey("AMOS_STUDIO");
		RequestContext.setProduct("AMOS_STUDIO_WEB");
		RequestContext.setToken(requestContext.getToken());
		return  ResponseHelper.buildResponse(Systemctl.regionClient.queryForTree(null).getResult());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/management-unit/tree")
	@ApiOperation(httpMethod = "GET", value = "管辖机构树", notes = "管辖机构树")
	public ResponseModel<Collection> managementUnitTree(@RequestParam(required = false)String orgCode) {
		RequestContext.setAppKey("AMOS_STUDIO");
		RequestContext.setProduct("AMOS_STUDIO_WEB");
		RequestContext.setToken(requestContext.getToken());
		Collection result = unitInfoServiceImpl.getManagementUnitTree(orgCode);
		return ResponseHelper.buildResponse(result);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@PostMapping(value = "/unitRegister")
	@ApiOperation(httpMethod = "POST", value = "单位注册", notes = "单位注册")
	public ResponseModel<UnitRegisterDto> save(@RequestBody UnitRegisterDto model) {
		try {
			RequestContext.setAppKey("AMOS_STUDIO");
			RequestContext.setProduct("AMOS_STUDIO_WEB");
			RequestContext.setToken(requestContext.getToken());
			model = unitInfoServiceImpl.registerUnit(model);
			return ResponseHelper.buildResponse(model);
		} catch (Exception e) {
			ResponseModel<UnitRegisterDto> response = new ResponseModel<>();
			HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
			response.setResult(null);
			response.setDevMessage(e.getMessage());
			response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
			response.setTraceId(RequestContext.getTraceId());
			response.setPath(request.getServletPath());
			return response;
		}

	}

	/**
	 * 判断用户号码是否存在
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/hasExistPhone/{phone}")
	@ApiOperation(httpMethod = "GET", value = "判断用户号码是否存在", notes = "判断用户号码是否存在")
	public ResponseModel hasExistPhone( @PathVariable(value = "phone") String phone) {
		try {
			return CommonResponseUtil.success(Privilege.agencyUserClient.checkLoginId(phone).getResult());
		} catch (Exception e) {
			return CommonResponseUtil.failure("该手机号已经注册");
		}
	}

	/**
	 * 发送手机号验证码
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/sendTelCode/{tel}")
	@ApiOperation(httpMethod = "GET", value = "发送手机号验证码", notes = "发送手机号验证码")
	public ResponseModel<Boolean> sendTelCode(@PathVariable(value = "tel") String tel,
											  @RequestParam(value = "type", required = false) String type) {

		if (ValidationUtil.isEmpty(tel)) {
			throw new BadRequest("参数校验失败.");
		}
		Boolean flag = true;
		HashMap<String, String> params = new HashMap<>(3);
		String code = this.getRandomCode();
		params.put("code",code);
		params.put("mobile",tel);
		params.put("smsCode", smsTempCode);
		try {
//			sendSmsCode.sendSmsCode(tel, s);
			Systemctl.smsClient.sendCommonSms(params).getResult();
			// code 保存到缓存中
			redisUtil.set(HYGF_USER_TEL + tel, code, time);
		} catch (Exception e) {
			throw new BadRequest("发送短信失败：" + e.getMessage());
		}
		return ResponseHelper.buildResponse(flag);
	}

	/**
	 * 验证手机号验证码是否成功
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/verifyTelCode/{tel}/{code}")
	@ApiOperation(httpMethod = "GET", value = "验证手机号验证码是否成功", notes = "验证手机号验证码是否成功")
	public ResponseModel<Boolean> verifyTelCode(@PathVariable(value = "tel") String adminTel, @PathVariable(value = "code") String code) {
		Boolean flag = false;
		if (ValidationUtil.isEmpty(adminTel) || ValidationUtil.isEmpty(code)) {
			throw new BadRequest("参数校验失败.");
		}
		if(redisUtil.hasKey(HYGF_USER_TEL + adminTel)) {
			String redisCode = redisUtil.get(HYGF_USER_TEL + adminTel).toString();
			if(code.equals(redisCode)) {
				flag = true;
			}
		}
		return ResponseHelper.buildResponse(flag);
	}

	private String getRandomCode(){
		String code = "";
		Random random = new Random();
		for (int i = 0; i < 6; i++) {
			int r = random.nextInt(10);
			code = code + r;
		}
		return code;

	}
}
