package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.entity.Commercial;
import com.yeejoin.amos.boot.module.hygf.api.entity.ExtendedInformation;
import com.yeejoin.amos.boot.module.hygf.api.entity.Information;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import com.yeejoin.amos.boot.module.hygf.api.entity.SurveyDetails;
import com.yeejoin.amos.boot.module.hygf.api.mapper.PeasantHouseholdMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IPeasantHouseholdService;
import com.yeejoin.amos.boot.module.hygf.api.dto.PeasantHouseholdDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 农户信息服务实现类
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Service
public class PeasantHouseholdServiceImpl extends BaseService<PeasantHouseholdDto,PeasantHousehold,PeasantHouseholdMapper> implements IPeasantHouseholdService {

    @Autowired
    SurveyInformationServiceImpl surveyInformationService;

    @Autowired
    SurveyDetailsServiceImpl surveyDetailsService;

    @Autowired
    InformationServiceImpl informationService;

    @Autowired
    ExtendedInformationServiceImpl extendedInformationService;

    @Autowired
    CommercialServiceImpl commercialService;

    public boolean deletePeasantHouseholdBySequenceNbr(Long sequenceNbr){
        PeasantHouseholdDto peasantHouseholdDto = this.queryBySeq(sequenceNbr);
        Long surveyInformationId = peasantHouseholdDto.getSurveyInformationId();
        //删除勘察基本信息
        surveyInformationService.deleteBySeq(surveyInformationId);
        //删除扩展信息
        QueryWrapper<ExtendedInformation> extendedInformationDeleteWrapper = new QueryWrapper<>();
        extendedInformationDeleteWrapper.lambda().eq(ExtendedInformation::getSurveyInformationId,surveyInformationId);
        extendedInformationService.getBaseMapper().delete(extendedInformationDeleteWrapper);
        //删除勘察明细
        QueryWrapper<SurveyDetails> surveyDetailsDeleteWrapper = new QueryWrapper<>();
        surveyDetailsDeleteWrapper.lambda().eq(SurveyDetails::getSurveyInformationId,surveyInformationId);
        surveyDetailsService.getBaseMapper().delete(surveyDetailsDeleteWrapper);
        //删除商务信息
        QueryWrapper<Commercial> commercialDeleteWrapper = new QueryWrapper<>();
        commercialDeleteWrapper.lambda().eq(Commercial::getSurveyInformationId,surveyInformationId);
        commercialService.getBaseMapper().delete(commercialDeleteWrapper);
        //删除资料归档信息
        QueryWrapper<Information> informationDeleteWrapper = new QueryWrapper<>();
        informationDeleteWrapper.lambda().eq(Information::getSurveyInformationId,surveyInformationId);
        informationService.getBaseMapper().delete(informationDeleteWrapper);
        //删除农户信息
        return this.deleteBySeq(sequenceNbr);
    }

    /**
     * 分页查询
     */
    public Page<PeasantHouseholdDto> queryForPeasantHouseholdPage(Page<PeasantHouseholdDto> page,String developerCode,@Condition(Operator.like) String ownersName)   {
        Page<PeasantHouseholdDto> peasantHouseholdDtoPage = this.queryForPage(page, null, false,developerCode,ownersName);
        List<PeasantHouseholdDto> records = peasantHouseholdDtoPage.getRecords();
        List<PeasantHouseholdDto> newRecords = records.stream().map(item -> {
            if (item.getSurveyOrNot() == 0) {
                item.setSurveyOrNotText("待勘察");
            } else if (item.getSurveyOrNot() == 1) {
                item.setSurveyOrNotText("已勘察");
            } else if (item.getSurveyOrNot() == 2) {
                item.setSurveyOrNotText("提交审核");
            }
            item.setProjectAddressName(item.getProjectAddressName()+"/"+item.getProjectAddressDetail());
            return item;
        }).collect(Collectors.toList());
        peasantHouseholdDtoPage.setRecords(newRecords);
        return peasantHouseholdDtoPage;
    }

    /**
     * 列表查询 示例
     */
    public List<PeasantHouseholdDto> queryForPeasantHouseholdList()   {
        return this.queryForList("" , false);
    }
}