package com.yeejoin.amos.boot.module.jxiop.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.Date;

/**
 * 地图片区
 *
 * @author system_generator
 * @date 2023-06-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "map_region",autoResultMap = true)
public class MapRegion extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 片区名称
     */
	@TableField("name")
    private String name;

    /**
     * 省份，中间用英文逗号隔开
     */
	@TableField(value = "province",typeHandler = FastjsonTypeHandler.class)
    private ArrayList<String> province;

    /**
     * 片区文字显示的省份
     */
	@TableField("modelName")
    private String modelName;

    /**
     * 偏移量
     */
	@TableField(value = "titlePos",typeHandler = FastjsonTypeHandler.class)
    private ArrayList<Integer> titlePos;

    /**
     * 片区中心点
     */
    @TableField(value = "cameraInfo", typeHandler = FastjsonTypeHandler.class)
    private CameraInfo cameraInfo;
}
