package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.yeejoin.amos.boot.module.jxiop.biz.dto.IndicatorsDto;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.SjglZsjZsbtzMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.utils.InfluxDButils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class CommonServiceImpl {
    @Autowired
    InfluxDButils influxDButils;


    @Autowired
    SjglZsjZsbtzMapper sjglZsjZsbtzMapper;

    /**
     * @deprecated  获取指标值总和
     * @param gatewayId 网关id 用于拼接sql语句
     * @param indicator 指标名称  查询条件-根据指标名称获取风速
     * @return 指标值总和
     */
    public Double getTotalByIndicatior(String gatewayId,String indicator){
        String sql = "SELECT * FROM indicators_"+gatewayId+" where equipmentIndexName='"+indicator+"'";
        Double totalvalue =  0.0;
        List<IndicatorsDto> indicatorsDtoList = influxDButils.getListData(sql,IndicatorsDto.class);
        List<Double> doubleList  = indicatorsDtoList.stream().map(indicatorsDto -> Double.parseDouble(indicatorsDto.getValue())).collect(Collectors.toList());
        totalvalue = doubleList.stream().mapToDouble(Double::doubleValue).sum();
        return totalvalue;
    }
    /**
     * @deprecated  获取指标值平均值
     * @param gatewayId 网关id 用于拼接sql语句
     * @param indicator 指标名称  查询条件-根据指标名称获取风速
     * @return 指标值总和
     */
    public Double getAvgvalueByIndicatior(String gatewayId,String indicator){
        String sql = "SELECT * FROM indicators_"+gatewayId+" where equipmentIndexName='"+indicator+"'";
        Double avageValue =  0.0;
        List<IndicatorsDto> indicatorsDtoList = influxDButils.getListData(sql,IndicatorsDto.class);
        List<Double> doubleList  = indicatorsDtoList.stream().map(indicatorsDto -> Double.parseDouble(indicatorsDto.getValue())).collect(Collectors.toList());
        avageValue = doubleList.stream().mapToDouble(Double::doubleValue).average().getAsDouble();
        return avageValue;
    }

    public Double getStationCapactityByStationWerks(String WERKS){
        return  sjglZsjZsbtzMapper.getStationCapactityByStationWerks(WERKS);
    }
}
