package com.yeejoin.amos.boot.module.jxiop.biz.utils;

import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import org.influxdb.dto.QueryResult;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
@Component
public class InfluxDButils {
    @Autowired
    InfluxDbConnection influxDbConnection;

    public <T> List<T> getListData(String sql, Class<T> clazz) {
        List<T> list = new ArrayList<>();
        try {
            QueryResult query = influxDbConnection.query(sql);
            List<QueryResult.Result> queryResults = query.getResults();
            for (QueryResult.Result result : queryResults) {
                List<QueryResult.Series> series = result.getSeries();
                if (series == null) {
                    continue;
                }
                for (QueryResult.Series serie : series) {
                    List<List<Object>> values = serie.getValues();
                    List<String> columns = serie.getColumns();
                    for (int i = 0; i < values.size(); ++i) {
                        T object = clazz.newInstance();
                        BeanWrapperImpl bean = new BeanWrapperImpl(object);
                        for (int j = 0; j < columns.size(); ++j) {
                            String k = columns.get(j);
                            Object v = values.get(i).get(j);
                            if ("time".equals(k)) {
                                continue;
                            }  else {
                                bean.setPropertyValue(k, v);
                            }
                        }
                        list.add(object);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public <T> List<T> getListData1(String sql, Class<T> clazz) {
        List<T> list = new ArrayList<>();
        try {
            QueryResult query = influxDbConnection.query(sql);
            List<QueryResult.Result> queryResults = query.getResults();
            for (QueryResult.Result result : queryResults) {
                List<QueryResult.Series> series = result.getSeries();
                if (series == null) {
                    continue;
                }
                for (QueryResult.Series serie : series) {
                    List<List<Object>> values = serie.getValues();
                    List<String> columns = serie.getColumns();
                    for (int i = 0; i < values.size(); ++i) {
                        T object = clazz.newInstance();
                        BeanWrapperImpl bean = new BeanWrapperImpl(object);
                        for (int j = 0; j < columns.size(); ++j) {
                            String k = columns.get(j).replace("last_","");
                            Object v = values.get(i).get(j);
                            System.out.println(k);
                            System.out.println(v);
                            if ("time".equals(k)) {
                                continue;
                            }  else {
//                                if(ObjectUtils.isEmpty(v)){
//                                    bean.setPropertyValue(k, "");
//                                }else{
                                    bean.setPropertyValue(k, v);
//                                }

                            }
                        }
                        list.add(object);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public <T> List<T> getListDataAll(String sql, Class<T> clazz) {
        List<T> list = new ArrayList<>();
        try {
            QueryResult query = influxDbConnection.query(sql);
            List<QueryResult.Result> queryResults = query.getResults();
            for (QueryResult.Result result : queryResults) {
                List<QueryResult.Series> series = result.getSeries();
                if (series == null) {
                    continue;
                }
                for (QueryResult.Series serie : series) {
                    List<List<Object>> values = serie.getValues();
                    List<String> columns = serie.getColumns();
                    for (int i = 0; i < values.size(); ++i) {
                        T object = clazz.newInstance();
                        BeanWrapperImpl bean = new BeanWrapperImpl(object);
                        for (int j = 0; j < columns.size(); ++j) {
                            String k = columns.get(j);
                            Object v = values.get(i).get(j);

                            bean.setPropertyValue(k, v);

                        }
                        list.add(object);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}
