package com.yeejoin.precontrol.common.dto;

import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 风险作业人员要求表
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Data
@ApiModel(value = "RiskWorkPersonRequirementDto", description = "风险作业人员要求表")
public class RiskWorkPersonRequirementDto extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "风险作业id")
    private Long riskWorkId;

    @ApiModelProperty(value = "人员类型")
    private String personType;

    @ApiModelProperty(value = "工种")
    private String workType;

    @ApiModelProperty(value = "资质要求")
    private String qualification;

    @ApiModelProperty(value = "三级安全考试")
    private String secExam;

    @ApiModelProperty(value = "专业技能考试")
    private String proSkillExam;

    @ApiModelProperty(value = "知识")
    private String knowledge;

    @ApiModelProperty(value = "考试题库类型（对应字典行业）")
    private String examSubjectType;

}
