package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
/**
 * 考试系统操作日志
 *
 * @author duanwei
 * @date 2021-11-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_ops_log")
@ApiModel(value="OpsLog对象", description="考试系统操作日志")
public class OpsLog extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "操作名称")
    private String opsOperation;

    @ApiModelProperty(value = "方法名称")
    private String methodName;

    @ApiModelProperty(value = "类名")
    private String clazzName;

    @ApiModelProperty(value = "参数")
    private String args;

    @ApiModelProperty(value = "ip地址")
    private String ipAddr;

    @ApiModelProperty(value = "操作人名称")
    private String realName;

    @ApiModelProperty(value = "操作人手机号")
    private String mobile;

    @ApiModelProperty(value = "操作人id")
    private Long personId;


}
