package com.yeejoin.precontrol.common.service;

import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.ArrayList;

/**
 * @author sqy
 */
public interface FileService {

    /**
     * 文件上传
     * @param file
     * @return
     * @throws IOException
     */
    String uploadfile(MultipartFile file) throws IOException;

    /**
     * 多文件上传
     * @param files
     * @return
     * @throws IOException
     */
    ArrayList<String> uploadfiles(MultipartFile[] files) throws IOException;

    /**
     * 获取图片base64
     * @param src
     * @return
     */
    String getImageBase64(String src);
    
    
    /**
     * 获取文件服务器地址
     * @return
     */
    String getDomain();

}
