package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import com.yeejoin.precontrol.common.service.IBaseService;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author duanwei
 * @date 2020-06-30
 */
@Service
@Slf4j
public class IBaseServiceImpl<S extends BaseEntity, R> implements IBaseService<S, R> {

    String mapperPath = "com.yeejoin.precontrol.common.mapper.";

    @Autowired
    SqlSession sqlSession;

    @Override
    public Boolean add(S obj1) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        return baseMapper.insert(obj1) > 0 ? true : false;
    }

    @Override
    public Boolean remove(S obj1, Long id) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        return baseMapper.deleteById(id) > 0 ? true : false;
    }

    @Override
    public Boolean removeByField(S obj1, String key, Long value) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        QueryWrapper<Object> eq = new QueryWrapper<>().eq(key, value);
        return baseMapper.delete(eq) > 0 ? true : false;
    }

    @Override
    public Boolean removeByFields(S obj1, String key, List<Long> value) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        QueryWrapper<Object> eq = new QueryWrapper<>().in(key, value);
        return baseMapper.delete(eq) > 0 ? true : false;
    }

    @Override
    public Boolean update(S obj1) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        return baseMapper.updateById(obj1) > 0 ? true : false;
    }

    @Override
    public Object findById(S obj1, Long id) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        return baseMapper.selectById(id);
    }


    @Override
    public List<Object> list(S obj1) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        return baseMapper.selectList(null);
    }

    @Override
    public List<Object> list(S obj1, Wrapper<S> queryWrapper) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        return baseMapper.selectList(queryWrapper);
    }

    @Override
    public List<Object> list(S obj1, Boolean isQueryWrapper, String... param) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.select(param);
        return baseMapper.selectList(queryWrapper1);
    }

    @Override
    public List<Object> list(S obj1, String key, Long value, String... param) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        QueryWrapper<Object> eq = new QueryWrapper<>().eq(key, value);
        eq.select(param);
        return baseMapper.selectList(eq);
    }

    @Override
    public List<Object> listByFields(S obj1, String key, List<Long> value, String... param) {
        BaseMapper baseMapper = getBaseMapper(obj1);
        QueryWrapper<Object> eq = new QueryWrapper<>().in(key, value);
        eq.select(param);
        return baseMapper.selectList(eq);
    }


    private BaseMapper getBaseMapper(S obj1) {
        Class<?> className = null;
        try {
            className = Class.forName(mapperPath + obj1.getClass().getSimpleName() + "Mapper");
        } catch (ClassNotFoundException e) {
            log.error("通用查询,实体无法解析Mapper,转换错误 :{}", obj1.getClass().getSimpleName());
        }
        return (BaseMapper) sqlSession.getMapper(className);
    }
}
