package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.EnterpriseLocusDto;
import com.yeejoin.precontrol.common.entity.PersonContract;
import com.yeejoin.precontrol.common.mapper.PersonContractMapper;
import com.yeejoin.precontrol.common.service.IPersonContractService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 人员合同信息 服务实现类
 *
 * @author duanwei
 * @date 2020-06-30
 */
@Service
public class PersonContractServiceImpl extends ServiceImpl<PersonContractMapper, PersonContract>
        implements IPersonContractService {

    @Value("${fileserver.domain}")
    String fileServerUrl;

    @Autowired
    private PersonContractMapper contractMapper;

    @Override
    public Page enterpriseLocusByPersonId(EnterpriseLocusDto enterpriseLocusDto, CommonPageableDto pageable) {
        if (pageable.getIsAll() == 1) {
            pageable.setPageNumber(0);
            pageable.setPageSize(Integer.MAX_VALUE);
        }
        Page<HashMap<String, Object>> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        List<HashMap<String, Object>> content = contractMapper.enterpriseLocusByPersonId(enterpriseLocusDto, page);

        content.forEach(c -> {
            String attachments = (String) c.get("attachments");
            if (attachments != null) {
                String[] split = attachments.split(",");
                List<String> arrList = Arrays.asList(split);
                List<String> filePath = new ArrayList<>();
                arrList.forEach(file -> {
                    filePath.add(fileServerUrl + file);
                });
                c.put("attachments", filePath);
            }
        });
        page.setRecords(content);
        return page;
    }
}
