package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.TableFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 项目历史轨迹
 *
 * @author duanwei
 * @date 2020-07-16
 */
@Data
public class ProjectHistoryVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目名称")
    private String name;

    @ApiModelProperty(value = "创建时间")
    private Date startTime;

    @ApiModelProperty(value = "创建时间")
    private Date endTime;

    @ApiModelProperty(value = "地区")
    private String region;

    @ApiModelProperty(value = "地区名称")
    private String regionName;

    @ApiModelProperty(value = "人员id")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "personName")
    private Long personId;

    @ApiModelProperty(value = "人员名称")
    private String personName;

    @ApiModelProperty(value = "项目id")
    @TableFormat(entityName = "rpm_project", fieldName = "name", operFieldName = "projectName")
    private Long projectId;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "分包商ID")
    @TableFormat(entityName = "rpm_company", fieldName = "name", operFieldName = "companyName")
    private Long companyId;

    @ApiModelProperty(value = "分包商名称")
    private String companyName;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;


    @ApiModelProperty(value = "工作年限")
    private String age;

}
