package com.yeejoin.precontrol.common.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.yeejoin.precontrol.common.annotations.TableFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 作业活动Vo
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class TaskPageVo {
    private static final long serialVersionUID = 1L;
    private Long id;
    @ApiModelProperty(value = "作业类型")
    @Excel(name = "作业类型", replace = {"技术交底_0", "三交三查_1", "违规管理_2"}, width = 20)
    private Long type;
    @ApiModelProperty(value = "任务单号")
    @Excel(name = "单号", width = 20)
    private Long taskNo;
    @ApiModelProperty(value = "方案名称")
    @Excel(name = "方案名称", width = 20)
    private String name;
    @ApiModelProperty(value = "发起人名称")
    @Excel(name = "发起人", width = 20)
    private String createPersonName;
    @Excel(name = "所属项目", width = 20)
    @ApiModelProperty(value = "项目名称")
    private String projectName;
    @Excel(name = "地区", width = 20)
    @ApiModelProperty(value = "地区名称")
    private String regionName;
    @ApiModelProperty(value = "创建时间")
    @Excel(name = "日期", exportFormat = "yyyy-MM-dd HH:mm:ss", width = 20)
    private Date createDate;
    @ApiModelProperty(value = "代号")
    private String code;
    @ApiModelProperty(value = "编号")
    private String number;
    @ApiModelProperty(value = "天气")
    private String weather;
    @ApiModelProperty(value = "发起人id")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "createPersonName")
    private Long createPersonId;
    @ApiModelProperty(value = "所属项目id")
    @TableFormat(entityName = "rpm_project", fieldName = "name", operFieldName = "projectName")
    private Long projectId;
    @ApiModelProperty(value = "任务状态")
    private Long status;
    @ApiModelProperty(value = "任务状态名称")
    private String statusName;
    @ApiModelProperty(value = "项目起始时间")
    private Date startTime;
    @ApiModelProperty(value = "任务结束时间")
    private Date taskEndTime;
    @ApiModelProperty(value = "地区")
    private String region;

    @ApiModelProperty(value = "任务的执行人")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "executeUserName")
    private Long executeUserId;
    private String executeUserName;

    @ApiModelProperty(value = "未完成任务的当前状态")
    private Long currentStatus;

    @ApiModelProperty(value = "是否是风险作业")
    private Long riskOperation;

    @ApiModelProperty(value = "风险作业名称")
    private String riskType;

    @ApiModelProperty(value = "创建人企业id")
    @TableFormat(entityName = "rpm_company", fieldName = "name", operFieldName = "companyName")
    private Long companyId;
    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "用于确认阅读，唯一的ID")
    private Long taskPersonId;

    @ApiModelProperty(value = "这次任务，人员的权限类型")
    private Long taskPersonRoleType;

    @ApiModelProperty(value = "违规类型名称")
    private String badTypeName;

    @ApiModelProperty(value = "作业票名称")
    private String workTicketName;

    @ApiModelProperty(value = "风险作业确认状态")
    private Long riskStatus;
    @ApiModelProperty(value = "施工人员确认状态")
    private Long builderStatus;
    
    @ApiModelProperty(value = "安全负责人")
    private String secPersonName;

    @ApiModelProperty(value = "计划开始时间")
    private Date planStartTime;

    @ApiModelProperty(value = "计划结束时间")
    private Date planEndTime;
    
    @ApiModelProperty(value = "超期天数")
    private int overDay;
    
    @ApiModelProperty(value = "阅读状态")
    private int readStatus;
    
    @ApiModelProperty(value = "这次任务，人员的权限类型")
    private String taskPersonRoleTypeName;
    
    private Long salaryConfirmId;
    
    private double contractTotalSalary;
    
    private double currentPaySalary;
    
    private String payBatch;
    
    private int personCount;
    
    private int confirmCount;
    
}
