package com.yeejoin.amos.boot.module.tdc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckModel;
import com.yeejoin.amos.boot.module.tdc.api.mapper.CheckModelMapper;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckModelService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xxz
 */
@Service
public class CheckModelImpl extends ServiceImpl<CheckModelMapper, CheckModel> implements CheckModelService {

    @Override
    public List<CheckModel> selectByOrgCode(String amosOrgCode) {
        LambdaQueryWrapper<CheckModel> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(CheckModel::getAmosOrgCode, amosOrgCode);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public CheckModel selectOneByDate() {
        LambdaQueryWrapper<CheckModel> wrapper = new LambdaQueryWrapper<>();
        wrapper.isNotNull(CheckModel::getCheckDate).orderByDesc(CheckModel::getCheckDate).last("limit 1");
        return baseMapper.selectOne(wrapper);
    }
}

