package com.yeejoin.amos.boot.module.tzs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 通话记录附件
 *
 * @author system_generator
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="VoiceRecordFileDto", description="通话记录附件")
public class VoiceRecordFileDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "文件地址")
    private String filePath;

    @ApiModelProperty(value = "通话类型")
    private String fileType;

    @ApiModelProperty(value = "电话")
    private String tel;

    @ApiModelProperty(value = "通话开始时间")
    private Date telStartTime;

    @ApiModelProperty(value = "通话结束时间")
    private Date telEndTime;

    @ApiModelProperty(value = "所属者id")
    private Long sourceId;

    @ApiModelProperty(value = "警情id")
    private Long alertId;

    @ApiModelProperty(value = "警情阶段")
    private String alertStage;

    @ApiModelProperty(value = "警情阶段code")
    private String alertStageCode;

    @ApiModelProperty(value = "通话时长")
    private String telTime;

    @ApiModelProperty(value = "通话记录id")
    private String connectId;

    @ApiModelProperty(value = "关联工单编号")
    private String workNum;

   @ApiModelProperty(value = "通话开始时间str")
   private String telStartTimeStr;

   @ApiModelProperty(value = "通话结束时间str")
   private String telEndTimeStr;

}
