package com.yeejoin.amos.boot.module.tzs.api.service;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * 联通cti 服务类
 *
 * @author system_generator
 * @date 2021-08-03
 */
public interface ICtiService {

    /**
     * 获取token
     * @return
     */
    String getAccessToken();

    /**
     * 获取登陆人坐席信息
     * @return
     */
    JSONObject getLoginInfo();

    /**
     * 根据话单id 查询话单详细信息
     * @param connectionid
     * @return
     */
    JSONArray getCallInfo(String connectionid);

    /**
     * 根据connectionid 下载录音 key 为录音地址 value 为录音名称
     * @return
     */
    Map<String, String> downLoadRecordFile(String connectionid);

    /**
     * 获取坐席登录情况
     * @return
     */
    Map<Object, Object> getUserStatus();

    /**
     * 根据坐席配置获取主叫号码
     */
    String getCallPhone();
}
