package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.tzs.api.dto.CtiDto;
import com.yeejoin.amos.boot.module.tzs.api.service.ICtiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.SimpleDateFormat;
import java.util.Map;

/**
 * 联通API controller
 *
 * @author kongfm
 * @date 2021-08-25
 */
@RestController
@Api(tags = "联通CTIApi")
@RequestMapping(value = "/cti")
public class CtiController extends BaseController {

	@Autowired
	private ICtiService ctiService;


    /**
     * 获取坐席登陆信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getCtiInfo")
	@ApiOperation(httpMethod = "GET", value = "获取坐席登陆信息", notes = "获取坐席登陆信息")
	public ResponseModel<JSONObject> getCtiInfo() {
		JSONObject loginData = ctiService.getLoginInfo();
		if(ValidationUtil.isEmpty(loginData)){
			return CommonResponseUtil.failure("当前用户不是坐席人员！");
		}
		return ResponseHelper.buildResponse(loginData);
	}

	/**
	 * 获取坐席登录情况
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getUserStatus")
	@ApiOperation(httpMethod = "GET", value = "获取坐席状态", notes = "获取坐席坐席状态")
	public ResponseModel<Map<Object, Object>> getUserStatus(){
		return ResponseHelper.buildResponse(ctiService.getUserStatus());
	}

	/**
	 * 获取坐席登陆信息
	 *	暴露公网
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.ANONYMOUS , needAuth = false)
	@PostMapping(value = "/ctiBack")
	@ApiOperation(httpMethod = "POST", value = "获取电话结束后回调信息", notes = "获取电话结束后回调信息")
	public JSONObject ctiBack(@RequestBody CtiDto ctiDto) {
		System.out.println("====================================");
		System.out.println(ctiDto);
		JSONObject result = new JSONObject();
		result.put("code","0");
		result.put("message","调用成功");
		return result;
	}

	/**
	 * 获取坐席登陆信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/info/{serviceconnectionid}")
	@ApiOperation(httpMethod = "GET", value = "获取通话话单详情", notes = "获取通话话单详情")
	public ResponseModel<JSONObject> getCallInfo(@PathVariable String serviceconnectionid) {
		JSONArray recordInfos = ctiService.getCallInfo(serviceconnectionid);
		if(recordInfos.size() == 0) {
			throw new BadRequest("未找到相关通话信息");
		}
		JSONObject recordInfo = recordInfos.getJSONObject(0);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
		return ResponseHelper.buildResponse(recordInfo);
	}

	/**
	 * 获取坐席技能组对应主叫号码信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/callPhone")
	@ApiOperation(httpMethod = "GET", value = "获取坐席技能组对应主叫号码信息", notes = "获取坐席技能组对应主叫号码信息")
	public ResponseModel<String> getCallPhone() {
		String callPhone = ctiService.getCallPhone();
		return ResponseHelper.buildResponse(callPhone);
	}
}
