package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum OverProjectFlowEnum {
    竣工资料上传确认("1", "竣工资料上传确认", "ZLSCQR", "竣工资料上传待确认", "审核确认", "待确认"),
    上传竣工资料("2", "上传竣工资料", "SCJGZL", "竣工资料待上传", "竣工资料上传", "待上传"),
    竣工资料审核并填写审核意见("3", "竣工资料审核并填写审核意见", "JGZLSH", "竣工资料待审核", "竣工资料审核", "待审核"),
    竣工流程结束("4","竣工流程结束！","JGLCJS","项目已竣工","","");
    private final String status;
    private final String name;
    private final String code;
    private final String taskDetailStatus;
    private String taskName;
    private String taskStatus;

    public static Map<String, String> getNameByStatusMap = new HashMap<String, String>();
    public static Map<String, String> getStatusByNameMap = new HashMap<String, String>();
    public static Map<String, String> getCodeByNameMap = new HashMap<String, String>();
    public static Map<String, String> getTaskDetailStatusMap = new HashMap<String, String>();
    public static Map<String,String> getTaskStatusMap = new HashMap<String, String>();
    public static Map<String,String> getTaskNameMap = new HashMap<String, String>();

    static {
        for (OverProjectFlowEnum projectInitiationEnum : OverProjectFlowEnum.values()) {
            getNameByStatusMap.put(projectInitiationEnum.status, projectInitiationEnum.name);
            getStatusByNameMap.put(projectInitiationEnum.name, projectInitiationEnum.status);
            getCodeByNameMap.put(projectInitiationEnum.name, projectInitiationEnum.code);
            getTaskDetailStatusMap.put(projectInitiationEnum.name, projectInitiationEnum.taskDetailStatus);
            getTaskStatusMap.put(projectInitiationEnum.name,projectInitiationEnum.taskStatus);
            getTaskNameMap.put(projectInitiationEnum.name,projectInitiationEnum.taskName);
        }
    }

}
