package com.yeejoin.amos.boot.module.ugp.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
//@EqualsAndHashCode(callSuper = true)
@ApiModel(value="WeldVerifyDto", description="焊口智能监验信息")
public class WeldVerifyDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "设备名称")
    private String name;

    @ApiModelProperty(value = "设备编号")
    private String code;

    @ApiModelProperty(value = "安装区域")
    private String installRegion;

    @ApiModelProperty(value = "工艺校验")
    private String craftStatus = "未校验";

    @ApiModelProperty(value = "耐压校验")
    private String voltageStatus = "未校验";

    @ApiModelProperty(value = "敷设校验")
    private String layStatus = "未校验";

    @ApiModelProperty(value = "定位校验")
    private String locationStatus = "未校验";

    @ApiModelProperty(value = "探伤校验")
    private String flawStatus = "未校验";

    @ApiModelProperty(value = "管沟校验")
    private String pipeDitchStatus = "未校验";

}
