package com.yeejoin.amos.boot.module.ugp.biz.emqx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.ugp.api.Enum.OrgEnum;
import com.yeejoin.amos.boot.module.ugp.api.entity.Company;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.CompanyServiceImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.OrgServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.component.emq.EmqxListener;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

@Component
@EnableScheduling
@Slf4j
public class PlatformUserTopicMessage extends EmqxListener {
    @Resource
    protected EmqKeeper emqKeeper;

    @Value("${amos.operation.log:/amos/operation/log}")
    private String amosOperationLog;

    @Resource
    private OrgServiceImpl orgService;

    @PostConstruct
    void init() throws Exception {
        emqKeeper.subscript(amosOperationLog, 1, this);
    }

    @Autowired
    CompanyServiceImpl companyService;

    @Value("${amos.agency.code}")
    String amosAgencyCode;

    @Autowired
    RedisUtils redisUtil;

    @Value("${amos.system.user.product:AMOS_STUDIO_WEB}")
    String product;

    @Value("${amos.system.user.app-key:AMOS_STUDIO}")
    String appKey;

    @Override
    public void processMessage(String topic, MqttMessage message) {
        RequestContext.setAppKey(appKey);
        RequestContext.setProduct(product);
        RequestContext.setToken(String.valueOf(redisUtil.get("platform_token")));
        JSONObject jsonObject = JSON.parseObject(message.toString());
        JSONObject result = jsonObject.getJSONObject("result");
        JSONObject dataResult = result.getJSONObject("result");
        String path = result.getString("path");
        String agencyCode = jsonObject.getString("agencyCode");
        if (!amosAgencyCode.equals(agencyCode)) {
            return;
        }
        try {
            if (StringUtils.isNotEmpty(path)) {
                if (path.contains("company")) {
                    Company company = companyService.saveOrUpdate(dataResult);
                    orgService.saveOrUpdateUser(dataResult, OrgEnum.公司.getKey());
                } else if (path.contains("department")) {
                    orgService.saveOrUpdateUser(dataResult, OrgEnum.部门.getKey());
                } else if (path.contains("agencyuser")) {
                    orgService.saveOrUpdateUser(dataResult, OrgEnum.普通人员.getKey());
                }
            }
        } catch (Exception e) {
            log.info("平台同步消息失败:{}", e.getMessage());
            e.printStackTrace();
        }
        log.info("平台推送消息同步完成");
    }


}
