package com.yeejoin.amos.boot.module.ugp.biz.framework;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.core.framework.PersonIdentify;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.api.exception.PermissionException;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.OrgServiceImpl;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.Map;

/**
 * @author DELL
 */
@Aspect
@Component
@ResponseBody
@Order(value = 1)
public class BusinessIdentifyAspect {
    @Autowired
    RedisUtils redisUtils;

    @Autowired
    OrgUsrServiceImpl orgUsrService;

    @Before(value = "@annotation(com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify) && @annotation(permission)")
    public void personIdentity(JoinPoint joinPoint, BusinessIdentify permission) throws PermissionException {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (permission.isNeedIdentity() && reginParams != null) {
            ReginParams.BusinessInfo businessInfo = new ReginParams.BusinessInfo();
            //company
            Long amosOrgId= reginParams.getCompany().getSequenceNbr();
            LambdaQueryWrapper<OrgUsr> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(OrgUsr :: getAmosOrgId,amosOrgId);
            OrgUsr companyOrgUsr = orgUsrService.getOne(wrapper);
            String companyName = companyOrgUsr.getBizOrgName();
            Long companySequenceNbr = companyOrgUsr.getSequenceNbr();
            String companyType = companyOrgUsr.getOrgExpandAttr1();
            if (ValidationUtil.isEmpty(companyType)) {
                companyType = companyOrgUsr.getBizOrgType();
            }
            businessInfo.setCompanyName(companyName);
            businessInfo.setAmosBizCode(amosOrgId);
            businessInfo.setCompanyType(companyType);
            businessInfo.setCompanySequenceNbr(companySequenceNbr);

            //User
            amosOrgId = reginParams.getUserModel().getSequenceNbr();
            wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(OrgUsr::getAmosOrgId,amosOrgId);
            OrgUsr userOrgUsr = orgUsrService.getOne(wrapper);
            String userName = userOrgUsr.getBizOrgName();
            Long userSequenceNbr = userOrgUsr.getSequenceNbr();
            String userType = userOrgUsr.getOrgExpandAttr1();
            if (ValidationUtil.isEmpty(userType)) {
                userType = userOrgUsr.getBizOrgType();
            }
            businessInfo.setUserSequenceNbr(userSequenceNbr);
            businessInfo.setUserName(userName);
            businessInfo.setUserType(userType);
            businessInfo.setAmosUserCode(amosOrgId);
            reginParams.setBusinessInfo(businessInfo);
            redisUtils.set(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken()), JSONObject.toJSONString(reginParams));
        }
    }

}
