package com.yeejoin.amos.boot.biz.common.dto;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * @author fengwang
 * @date 2021-06-19.
 */
@Data
@Accessors(chain = true)
@ApiModel(value="OrgMenuVo", description="树菜单")
public class OrgMenuDto {
    private Long key;
    private Long value;
    private String title;
    private String name;
    private Long parentId;
    private Boolean leaf = true;
    private Boolean isLeaf = true;
    private List<OrgMenuDto> children;
    private String bizOrgType;
    private String bizOrgCode;
    
    public Boolean getLeaf() {
    	return ObjectUtils.isEmpty(children);
    }
    
    public Boolean getIsLeaf() {
    	return ObjectUtils.isEmpty(children);
    }
    
    public Long getValue() {
    	return key;
    }
    
    public String getName() {
    	return title;
    }
    
    public OrgMenuDto(Long key, String title, Long parentId, String bizOrgType, boolean leaf, String bizOrgCode) {
        super();
        this.key = key;
        this.title = title;
        this.parentId = parentId;
        this.bizOrgType = bizOrgType;
        this.leaf = leaf;
        this.bizOrgCode = bizOrgCode;
    }
    public OrgMenuDto(Long key, String title, Long parentId, String bizOrgType, boolean leaf) {
        super();
        this.key = key;
        this.title = title;
        this.parentId = parentId;
        this.bizOrgType = bizOrgType;
        this.leaf = leaf;
    }

    public OrgMenuDto(Long key, String title, Long parentId, String bizOrgType) {
        this.key = key;
        this.title = title;
        this.parentId = parentId;
        this.bizOrgType = bizOrgType;
    }

	public OrgMenuDto() {
		// TODO Auto-generated constructor stub
	}

    public OrgMenuDto(Long key, Long value, String title, String name, List<OrgMenuDto> children) {
        this.key = key;
        this.value = value;
        this.title = title;
        this.name = name;
        this.children = children;
    }
}
