package com.yeejoin.amos.api.householdapi.face.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.qiniu.util.Json;
import com.yeejoin.amos.api.householdapi.Utils.GoodWeRequestUtil;
import com.yeejoin.amos.api.householdapi.constant.GoLangConstant;
import com.yeejoin.amos.api.householdapi.constant.GoodWeConstant;
import com.yeejoin.amos.api.householdapi.face.dto.*;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverter;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverterElectricity;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.*;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterElectricityMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.*;
import com.yeejoin.amos.api.householdapi.face.service.GoodWeDataAcquisitionService;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;

import org.apache.ibatis.javassist.bytecode.stackmap.BasicBlock.Catch;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.server.Jsp;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class GoodWeDataAcquisitionServiceImpl implements GoodWeDataAcquisitionService {
	@Autowired
	GoodWeRequestUtil goodWeRequestUtil;
	@Autowired
	GoodWeStationMonitorListMapper goodWeStationMonitorListMapper;
	@Autowired
	GoodWeStationDetailMapper goodWeStationDetailMapper;
	@Autowired
	JpStationMapper jpStationMapper;

	@Autowired
	private JpInverterMapper jpInverterMapper;
	@Autowired
	private HYGFJPStationPowerHistoryMapper hygfjpStationPowerHistoryMapper;
	// 户用光伏逆变器历史mapper
	@Autowired
	private HYGFJPInverterHistoryMapper hygfjpInverterHistoryMapper;
	// 户用光伏采集器历史mapper
	@Autowired
	private HYGFJPCollectorHistoryMapper hygfjpCollectorHistoryMapper;
	// 户用光伏逆变器告警
	@Autowired
	private HYGFJPInverterWarnMapper hygfjpInverterWarnMapper;
	// 户用光伏逆变器历史mapper
	@Autowired
	private HYGFJPInverterElecHistoryMapper hygfjpInverterElecHistoryMapper;
	// 户用光伏日发电量
	@Autowired
	private JpInverterElectricityMapper jpInverterElectricityMapper;
	@Autowired
	private TdHYGFInverterDayGenerateMapper tdHYGFInverterDayGenerateMapper;
	@Autowired
	private TdHYGFInverterMonthGenerateMapper tdHYGFInverterMonthGenerateMapper;
	@Autowired
	private TdHYGFInverterYearGenerateMapper tdHYGFInverterYearGenerateMapper;
	@Autowired
	private HYGFJPDayPowerMapper hygfjpDayPowerMapper;
	@Autowired
	private TdHYGFStationMonthGenerateMapper TdHYGFStationMonthGenerateMapper;
	@Autowired
	private TdHYGFStationYearGenerateMapper TdHYGFStationYearGenerateMapper;
	@Autowired
	private TdHYGFStationAllGenerateMapper TdHYGFStationAllGenerateMapper;

	@Autowired
	private TdHYGFInverterTotalGenerateMapper tdHYGFInverterTotalGenerateMapper;
	@Autowired
	TdJpStationMapper tdJpStationMapper;

	final static Logger logger = LoggerFactory.getLogger(GoodWeDataAcquisitionServiceImpl.class);

	final static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@Override
	@Scheduled(cron = "${dataRequstScheduled.GoodWe}")
	@Async
	public void stationList() {
		long ts = System.currentTimeMillis();
		logger.info("-------固德威同步场站和告警开始" + ts + "------- " + sdf.format(new Date()));
		HashMap<String, Object> requestInfo = new HashMap<>();
		requestInfo.put("page_index", 1);
		requestInfo.put("page_size", 200);
		// requestInfo.put("key", "龙虎山北区");
		String requstParam = JSON.toJSONString(requestInfo);
		String today = DateUtil.today();
		String hour = new Date().getHours() + ":00";
		List<GoodWeStationMonitorDto> goodWeStationLists = goodWeRequestUtil.getResPonse(
				GoodWeConstant.stationListStatusUrl, GoodWeConstant.requestPost, requstParam,
				GoodWeConstant.resovleRule_data_list, GoodWeStationMonitorDto.class);
		if (goodWeStationLists.size() > 0) {
			goodWeStationLists.forEach(goodWeStationMonitorDto -> {
				GoodWeStationMonitorList goodWeStationList = new GoodWeStationMonitorList();
				BeanUtil.copyProperties(goodWeStationMonitorDto, goodWeStationList);
				goodWeStationList.setCreatedTime(System.currentTimeMillis());
				goodWeStationMonitorListMapper.insert(goodWeStationList);
				JpStation jpStation = jpStationMapper
						.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.GDW.getCode())
								.eq("third_station_id", goodWeStationList.getPowerstation_id()));
				if (ObjectUtils.isEmpty(jpStation)) {
					jpStation = new JpStation();
				}
				jpStation.setThirdStationId(goodWeStationList.getPowerstation_id());
				jpStation.setThirdCode(PVProducerInfoEnum.GDW.getCode());
				jpStation.setSnCode(goodWeStationList.getPowerstation_id());
				jpStation.setCapacity(goodWeStationList.getCapacity());
				jpStation.setName(goodWeStationList.getStationname());
				jpStation.setPrice(0.42);
				jpStation.setAddress(goodWeStationList.getLocation());
				jpStation.setLatitude(goodWeStationList.getLatitude());
				jpStation.setLongitude(goodWeStationList.getLongitude());
				jpStation.setUserName(goodWeStationList.getOwner_name() == null ? goodWeStationList.getStationname()
						: goodWeStationList.getOwner_name());
				jpStation.setUserPhone(goodWeStationList.getOwner_phone());
				jpStation.setStationContact(goodWeStationList.getOwner_name());
				jpStation.setModuleCount(0);
				jpStation.setRealTimePower(
						goodWeStationList.getPac() != null ? goodWeStationList.getPac() * GoodWeConstant.wToKw : null);
				jpStation.setState(goodWeStationList.getStatus() != null
						? GoodWeConstant.stationStaus.get(goodWeStationList.getStatus() + "")
						: null);
				jpStation.setDayGenerate(goodWeStationList.getEday());
				jpStation.setDayIncome(goodWeStationList.getEday_income());
				jpStation.setAccumulatedPower(goodWeStationList.getEtotal());
				jpStation.setCumulativeIncome(goodWeStationList.getEtotal_income());
				jpStation.setType(goodWeStationList.getPowerstation_type());
				jpStation.setRecDate(new Date());
				if (ObjectUtils.isEmpty(jpStation.getSequenceNbr())) {
					jpStation.setCreateTime(new Date(goodWeStationList.getCreatedTime()));
					if (ObjectUtils.isNotEmpty(goodWeStationList.getTurnon_time())) {
						jpStation.setAccessTime(new Date(goodWeStationList.getTurnon_time()));
					}

					jpStationMapper.insert(jpStation);
				} else {
					jpStationMapper.updateById(jpStation);
				}

				try {
					this.inverAlramInfo(goodWeStationList.getPowerstation_id());
				} catch (Exception e) {
					e.printStackTrace();
				}

				// 增加td 电站区域公司，经销商绑定表
//                TdJpStation tdJpStation = tdJpStationMapper.selectOne(new QueryWrapper<TdJpStation>().
//                        eq("third_code",PVProducerInfoEnum.GDW.getCode()).
//                        eq("third_station_id",  jpStation.getThirdStationId()));
//                //判断是否存在
//                if (org.springframework.util.ObjectUtils.isEmpty(tdJpStation)) {
//                    tdJpStation = new TdJpStation();
//                }
//                tdJpStation.setAmosCompanyCode(jpStation.getAmosCompanyCode());
//                tdJpStation.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
//                tdJpStation.setThirdStationId( jpStation.getThirdStationId());
//                tdJpStation.setThirdCode(PVProducerInfoEnum.GDW.getCode());
//                tdJpStation.setIsDelete(jpStation.getIsDelete()?1:0);
//                tdJpStation.setStationName(jpStation.getName());
//                if (!org.springframework.util.ObjectUtils.isEmpty(tdJpStation.getCreatedTime())) {
//                    tdJpStationMapper.insert(tdJpStation);
//                } else {
//                    tdJpStation.setCreatedTime(System.currentTimeMillis());
//                    tdJpStationMapper.insert(tdJpStation);
//                }

				HYGFJPStationPowerHistory hygfjpStationPowerHistory = new HYGFJPStationPowerHistory();
				hygfjpStationPowerHistory.setCreatedTime(System.currentTimeMillis());
				hygfjpStationPowerHistory.setThirdStationId(jpStation.getThirdStationId());
				hygfjpStationPowerHistory.setPower(jpStation.getRealTimePower());
				hygfjpStationPowerHistory.setThirdCode(jpStation.getThirdCode());
				hygfjpStationPowerHistory.setTime(System.currentTimeMillis());

				// 新加
				hygfjpStationPowerHistory.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				hygfjpStationPowerHistory.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				hygfjpStationPowerHistory.setStationName(jpStation.getName());
				hygfjpStationPowerHistory.setStationState(jpStation.getState());

				hygfjpStationPowerHistoryMapper.insert(hygfjpStationPowerHistory);
				HYGFJPDayPower hygfjpDayPower = hygfjpDayPowerMapper.selectOne(new QueryWrapper<HYGFJPDayPower>()
						.eq("third_station_id", jpStation.getThirdStationId()).eq("year_month_day", today).eq("hour", hour));
				if (org.springframework.util.ObjectUtils.isEmpty(hygfjpDayPower)) {
					hygfjpDayPower = new HYGFJPDayPower();
				}
				hygfjpDayPower.setThirdStationId(goodWeStationList.getPowerstation_id());
				hygfjpDayPower.setHour(hour);
				hygfjpDayPower.setYearMonthDay(today);
				hygfjpDayPower.setPower(jpStation.getRealTimePower());

				// 新加
				hygfjpDayPower.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				hygfjpDayPower.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				hygfjpDayPower.setStationName(jpStation.getName());
				hygfjpDayPower.setStationState(jpStation.getState());

				if (org.springframework.util.ObjectUtils.isEmpty(hygfjpDayPower.getCreatedTime())) {
					hygfjpDayPower.setCreatedTime(System.currentTimeMillis());
					hygfjpDayPowerMapper.insert(hygfjpDayPower);
				} else {
					hygfjpDayPowerMapper.insert(hygfjpDayPower);
				}
				Date today1 = new Date();
				// 户用场站日发电量
				TdHYGFStationMonthGenerate TdHYGFStationMonthGenerate = TdHYGFStationMonthGenerateMapper
						.selectOne(new QueryWrapper<TdHYGFStationMonthGenerate>()
								.eq("third_station_id", jpStation.getThirdStationId())
								.eq("day_time", DateUtil.format(today1, "yyyy-MM-dd"))
								.eq("year_month", DateUtil.format(today1, "yyyy-MM")));
				if (org.springframework.util.ObjectUtils.isEmpty(TdHYGFStationMonthGenerate)) {
					TdHYGFStationMonthGenerate = new TdHYGFStationMonthGenerate();
				}
				TdHYGFStationMonthGenerate.setThirdStationId(jpStation.getThirdStationId());
				TdHYGFStationMonthGenerate.setDayTime(DateUtil.format(today1, "yyyy-MM-dd"));
				TdHYGFStationMonthGenerate.setYearMonth(DateUtil.format(today1, "yyyy-MM"));
				TdHYGFStationMonthGenerate.setGenerate(jpStation.getDayGenerate());
				TdHYGFStationMonthGenerate.setFullhour(goodWeStationList.getTo_hour());
				TdHYGFStationMonthGenerate.setIncome(jpStation.getDayIncome());
				// 新加
				TdHYGFStationMonthGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				TdHYGFStationMonthGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				TdHYGFStationMonthGenerate.setStationName(jpStation.getName());
				TdHYGFStationMonthGenerate.setStationState(jpStation.getState());

				if (org.springframework.util.ObjectUtils.isEmpty(TdHYGFStationMonthGenerate.getCreatedTime())) {
					TdHYGFStationMonthGenerate.setCreatedTime(System.currentTimeMillis());
					TdHYGFStationMonthGenerateMapper.insert(TdHYGFStationMonthGenerate);
				} else {
					TdHYGFStationMonthGenerateMapper.insert(TdHYGFStationMonthGenerate);
				}
				// 户用场站月发电量
				TdHYGFStationYearGenerate TdHYGFStationYearGenerate = TdHYGFStationYearGenerateMapper
						.selectOne(new QueryWrapper<TdHYGFStationYearGenerate>()
								.eq("third_station_id", jpStation.getThirdStationId())
								.eq("month_time", DateUtil.format(today1, "yyyy-MM"))
								.eq("year", DateUtil.format(today1, "yyyy")));
				if (org.springframework.util.ObjectUtils.isEmpty(TdHYGFStationYearGenerate)) {
					TdHYGFStationYearGenerate = new TdHYGFStationYearGenerate();
				}
				TdHYGFStationYearGenerate.setThirdStationId(jpStation.getThirdStationId());
				TdHYGFStationYearGenerate.setMonthTime(DateUtil.format(today1, "yyyy-MM"));
				TdHYGFStationYearGenerate.setYear(DateUtil.format(today1, "yyyy"));
				TdHYGFStationYearGenerate.setGenerate(jpStation.getMonthGenerate());
				if (ObjectUtils.isNotEmpty(jpStation.getMonthGenerate())) {
					TdHYGFStationYearGenerate.setFullhour(jpStation.getMonthGenerate() / jpStation.getCapacity());
				}
				TdHYGFStationYearGenerate.setIncome(jpStation.getMonthIncome());
				// 新加
				TdHYGFStationYearGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				TdHYGFStationYearGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				TdHYGFStationYearGenerate.setStationName(jpStation.getName());
				TdHYGFStationYearGenerate.setStationState(jpStation.getState());

				if (org.springframework.util.ObjectUtils.isEmpty(TdHYGFStationYearGenerate.getCreatedTime())) {
					TdHYGFStationYearGenerate.setCreatedTime(System.currentTimeMillis());
					TdHYGFStationYearGenerateMapper.insert(TdHYGFStationYearGenerate);
				} else {
					TdHYGFStationYearGenerateMapper.insert(TdHYGFStationYearGenerate);
				}
				// 户用场站年发电量
				TdHYGFStationAllGenerate TdHYGFStationAllGenerate = TdHYGFStationAllGenerateMapper
						.selectOne(new QueryWrapper<TdHYGFStationAllGenerate>()
								.eq("third_station_id", jpStation.getThirdStationId())
								.eq("year_time", DateUtil.format(today1, "yyyy"))
								.eq("year", DateUtil.format(today1, "yyyy")));
				if (org.springframework.util.ObjectUtils.isEmpty(TdHYGFStationAllGenerate)) {
					TdHYGFStationAllGenerate = new TdHYGFStationAllGenerate();
				}
				TdHYGFStationAllGenerate.setThirdStationId(jpStation.getThirdStationId());
				TdHYGFStationAllGenerate.setYearTime(DateUtil.format(today1, "yyyy"));
				TdHYGFStationAllGenerate.setYear(DateUtil.format(today1, "yyyy"));
				TdHYGFStationAllGenerate.setGenerate(jpStation.getYearGenerate());
				TdHYGFStationAllGenerate.setFullhour(jpStation.getYearGenerate() / jpStation.getCapacity());
				TdHYGFStationAllGenerate.setIncome(jpStation.getYearIncome());
				// 新加
				TdHYGFStationAllGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				TdHYGFStationAllGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				TdHYGFStationAllGenerate.setStationName(jpStation.getName());
				TdHYGFStationAllGenerate.setStationState(jpStation.getState());

				if (org.springframework.util.ObjectUtils.isEmpty(TdHYGFStationAllGenerate.getCreatedTime())) {
					TdHYGFStationAllGenerate.setCreatedTime(System.currentTimeMillis());
					TdHYGFStationAllGenerateMapper.insert(TdHYGFStationAllGenerate);
				} else {
					TdHYGFStationAllGenerateMapper.insert(TdHYGFStationAllGenerate);
				}
			});
		}
		logger.info("-------固德威同步场站和告警结束" + ts + "------- " + sdf.format(new Date()));
	}

	@Override
	@Scheduled(cron = "${dataRequstScheduled.GoodWe}")
	@Async
	public void stationDetail() {
		long ts = System.currentTimeMillis();
		logger.info("-------固德威同步场站详情开始" + ts + "------- " + sdf.format(new Date()));
		List<String> stationIds = goodWeStationMonitorListMapper.getStationIds();
		stationIds.forEach(stationId -> {
			HashMap<String, Object> requestInfo = new HashMap<>();
			String requstParam = JSON.toJSONString(requestInfo);
			String apiurl = GoodWeConstant.stationDetailUrl + "?id=" + stationId;
			List<GoodWeStationDetail> goodWeStationDetails = goodWeRequestUtil.getResPonse(apiurl,
					GoodWeConstant.requestGet, requstParam, GoodWeConstant.resovleRule_data, GoodWeStationDetail.class);
			if (goodWeStationDetails.size() > 0) {
				goodWeStationDetails.forEach(goodWeStationDetail -> {
					goodWeStationDetail.setCreatedTime(System.currentTimeMillis());
					goodWeStationDetailMapper.insert(goodWeStationDetail);
					JpStation jpStation = jpStationMapper
							.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.GDW.getCode())
									.eq("third_station_id", goodWeStationDetail.getPowerstation_id()));
					if (ObjectUtils.isEmpty(jpStation)) {
						jpStation = new JpStation();
					}
					jpStation.setUserName(goodWeStationDetail.getOwner_name());
					jpStation.setUserPhone(goodWeStationDetail.getOwner_phone());
					jpStation.setStationContact(goodWeStationDetail.getOwner_name());
					jpStation.setAccessTime(
							DateUtil.parse(goodWeStationDetail.getTurnon_time(), DatePattern.NORM_DATETIME_PATTERN));
					if (!ObjectUtils.isEmpty(jpStation.getSequenceNbr())) {
						jpStationMapper.updateById(jpStation);
					}
				});
			}
		});
		logger.info("-------固德威同步场站详情结束" + ts + "------- " + sdf.format(new Date()));
	}

	@Override
	@Scheduled(cron = "${dataRequstScheduled.GoodWe}")
	@Async
	public void stationMonthGen() {
		long ts = System.currentTimeMillis();
		logger.info("-------固德威同步场站月发电量开始" + ts + "------- " + sdf.format(new Date()));
		List<String> stationIds = goodWeStationMonitorListMapper.getStationIds();
		stationIds.forEach(stationId -> {
			String currentMonth = DateUtil.format(new Date(), "yyyyMM");
			HashMap<String, Object> requestInfo = new HashMap<>();
			requestInfo.put("id", stationId);
			requestInfo.put("date", DateUtil.today());
			requestInfo.put("count", 0);
			requestInfo.put("type", 1);
			String requstParam = JSON.toJSONString(requestInfo);
			List<GoodWEGenStation> goodWEGenStations = goodWeRequestUtil.getResPonse(GoodWeConstant.stationGenUrl,
					GoodWeConstant.requestPost, requstParam, GoodWeConstant.resovleRule_data, GoodWEGenStation.class);
			List<GoodWEGenStation> currentMonthGenStations = goodWEGenStations.stream()
					.filter(goodWEGenStation -> goodWEGenStation.getDate().equals(currentMonth))
					.collect(Collectors.toList());
			currentMonthGenStations.forEach(goodWEGenStation -> {
				JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>()
						.eq("third_code", PVProducerInfoEnum.GDW.getCode()).eq("third_station_id", stationId));
				if (ObjectUtils.isNotEmpty(jpStation)) {
					jpStation.setMonthGenerate(Double.parseDouble(goodWEGenStation.getPower()));
					jpStation.setMonthIncome(jpStation.getMonthGenerate() * 0.42);
					jpStationMapper.updateById(jpStation);
//                    if(jpStation.getName().contains("刘国荣")) 
//                    {
//                    	System.out.println(jpStation);
//                    }
				}
			});
		});
		logger.info("-------固德威同步场站月发电量结束" + ts + "------- " + sdf.format(new Date()));
	}

	@Override
	@Scheduled(cron = "${dataRequstScheduled.GoodWe}")
	@Async
	public void stationYearGen() {
		long ts = System.currentTimeMillis();
		logger.info("-------固德威同步场站年发电量开始" + ts + "------- " + sdf.format(new Date()));
		List<String> stationIds = goodWeStationMonitorListMapper.getStationIds();
		stationIds.forEach(stationId -> {
			String currentYear = DateUtil.format(new Date(), "yyyy");
			HashMap<String, Object> requestInfo = new HashMap<>();
			requestInfo.put("id", stationId);
			requestInfo.put("date", DateUtil.today());
			requestInfo.put("count", 0);
			requestInfo.put("type", 2);
			String requstParam = JSON.toJSONString(requestInfo);
			List<GoodWEGenStation> goodWEGenStations = goodWeRequestUtil.getResPonse(GoodWeConstant.stationGenUrl,
					GoodWeConstant.requestPost, requstParam, GoodWeConstant.resovleRule_data, GoodWEGenStation.class);
			List<GoodWEGenStation> currentMonthGenStations = goodWEGenStations.stream()
					.filter(goodWEGenStation -> goodWEGenStation.getDate().equals(currentYear))
					.collect(Collectors.toList());
			currentMonthGenStations.forEach(goodWEGenStation -> {
				JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>()
						.eq("third_code", PVProducerInfoEnum.GDW.getCode()).eq("third_station_id", stationId));
				if (ObjectUtils.isNotEmpty(jpStation)) {
					jpStation.setYearGenerate(Double.parseDouble(goodWEGenStation.getPower()));
					jpStation.setYearIncome(jpStation.getYearGenerate() * 0.42);
					jpStationMapper.updateById(jpStation);
				}
			});
		});
		logger.info("-------固德威同步场站年发电量开始" + ts + "------- " + sdf.format(new Date()));
	}

	@Override
	public void collectorList() {

	}

	@Override
	public void collectorDetail() {

	}

	@Override
	@Scheduled(cron = "${dataRequstScheduled.GoodWe}")
	@Async
	public void inverterList() {
		long ts = System.currentTimeMillis();
		logger.info("-------固德威同步逆变器开始" + ts + "------- " + sdf.format(new Date()));
		List<String> stationIds = goodWeStationMonitorListMapper.getStationIds();
		stationIds.stream().forEach(stationId -> {
			HashMap<String, Object> requestInfo = new HashMap<>();
			requestInfo.put("page_index", 1);
			requestInfo.put("page_size", 100);
			requestInfo.put("pw_id", stationId);
			JpStation jpStation = jpStationMapper.selectOne(
					new QueryWrapper<JpStation>().eq("third_station_id", stationId).orderByDesc("create_time"));
			String requstParam = JSON.toJSONString(requestInfo);
			List<GoodWeINverterDetailDto> inverterDetailDtoList = goodWeRequestUtil.getResPonse(
					GoodWeConstant.queryInventerUrl, GoodWeConstant.requestPost, requstParam,
					GoodWeConstant.resovleRule_data_list, GoodWeINverterDetailDto.class);
			inverterDetailDtoList.forEach(goodWeINverterDetailDto -> {
//                System.out.println(goodWeINverterDetailDto.getIt_sn());
				JpInverter jpInverter = jpInverterMapper.selectOne(
						new QueryWrapper<JpInverter>().eq("third_station_id", goodWeINverterDetailDto.getPw_id())
								.eq("third_code", PVProducerInfoEnum.GDW.getCode())
								.eq("sn_code", goodWeINverterDetailDto.getIt_sn()));
				if (org.springframework.util.ObjectUtils.isEmpty(jpInverter)) {
					jpInverter = new JpInverter();
				}
				jpInverter.setName(goodWeINverterDetailDto.getIt_name());
				jpInverter.setSnCode(goodWeINverterDetailDto.getIt_sn());
				jpInverter.setUpdateTime(new Date());
				jpInverter.setId(String.valueOf(goodWeINverterDetailDto.getId()));
				jpInverter.setCapacity(goodWeINverterDetailDto.getIt_capacity());
				jpInverter.setThirdStationId(goodWeINverterDetailDto.getPw_id());
				jpInverter.setThirdCode(PVProducerInfoEnum.GDW.getCode());
				if (ObjectUtil.isNotEmpty(jpStation) && StringUtils.isNotEmpty(jpStation.getName())) {
					jpInverter.setStationName(jpStation.getName());
				}
				jpInverter.setRecDate(new Date());
				if (!org.springframework.util.ObjectUtils.isEmpty(jpInverter.getSequenceNbr())) {
					jpInverterMapper.updateById(jpInverter);
				} else {
					jpInverterMapper.insert(jpInverter);
				}
			});
		});
		logger.info("-------固德威同步逆变器结束" + ts + "------- " + sdf.format(new Date()));
	}

	@Override
	@Scheduled(cron = "${dataRequstScheduled.GoodWe}")
	@Async
	public void inverterDetail() {
		long ts = System.currentTimeMillis();
		logger.info("-------固德威同步逆变器详情开始" + ts + "------- " + sdf.format(new Date()));
		List<String> goodweSnList = jpInverterMapper.getGoodWeSnCodes();
		List<List<String>> splitList = Lists.partition(goodweSnList, 50);
		HashMap<String, Object> requestInfo = new HashMap<>();
		String requstParam = JSON.toJSONString(requestInfo);
		for (int i = 0; i < splitList.size(); i++) {
			String requestSns = splitList.get(i).stream().map(s -> "sns=" + s).collect(Collectors.joining("&"));
			String apiUrl = GoodWeConstant.getInventersDatas + "?" + requestSns;
			List<GoodWeInverterCurrentDataDto> list = goodWeRequestUtil.getResPonse(apiUrl, GoodWeConstant.requestGet,
					requstParam, GoodWeConstant.resovleRule_data_list, GoodWeInverterCurrentDataDto.class);
			list.forEach(goodWeInverterCurrentDataDto -> {
				JpInverter jpInverter = jpInverterMapper
						.selectOne(new QueryWrapper<JpInverter>().eq("third_code", PVProducerInfoEnum.GDW.getCode())
								.eq("sn_code", goodWeInverterCurrentDataDto.getSn()));
				jpInverter.setIgbtTemperature(String.valueOf(goodWeInverterCurrentDataDto.getTempperature()));
				jpInverter.setDayPowerGeneration(goodWeInverterCurrentDataDto.getEday());
				jpInverter.setCapacity(goodWeInverterCurrentDataDto.getCapacity());
				jpInverterMapper.updateById(jpInverter);
				JSONObject hanlderResult = JSONObject
						.parseObject(JSON.toJSONString(goodWeInverterCurrentDataDto.getD()));
				for (int k = 1; k < 3; k++) {
					JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper
							.selectOne(new QueryWrapper<JpInverterElectricity>()
									.eq("sn_code", goodWeInverterCurrentDataDto.getSn()).eq("type", "交流")
									.eq("name", "AC" + k));
					if (org.springframework.util.ObjectUtils.isEmpty(jpInverterElectricity)) {
						jpInverterElectricity = new JpInverterElectricity();
					}
					jpInverterElectricity.setInverterId(jpInverter.getId());
					jpInverterElectricity.setSnCode(goodWeInverterCurrentDataDto.getSn());
					jpInverterElectricity.setThirdCode(PVProducerInfoEnum.GDW.getCode());
					jpInverterElectricity.setThirdStationId(jpInverter.getThirdStationId());
					jpInverterElectricity.setType("交流");
					jpInverterElectricity.setName("AC" + k);
					jpInverterElectricity.setVoltage(Double.valueOf(hanlderResult.get("vac" + k).toString()));
					jpInverterElectricity.setCurrent(Double.valueOf(hanlderResult.get("iac" + k).toString()));
					if (org.springframework.util.ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
						jpInverterElectricityMapper.insert(jpInverterElectricity);
					} else {
						jpInverterElectricityMapper.updateById(jpInverterElectricity);
					}
				}
				for (int k1 = 1; k1 < 4; k1++) {
					JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper
							.selectOne(new QueryWrapper<JpInverterElectricity>()
									.eq("sn_code", goodWeInverterCurrentDataDto.getSn()).eq("type", "直流")
									.eq("name", "PV" + k1));
					if (org.springframework.util.ObjectUtils.isEmpty(jpInverterElectricity)) {
						jpInverterElectricity = new JpInverterElectricity();
					}
					jpInverterElectricity.setInverterId(jpInverter.getId());
					jpInverterElectricity.setSnCode(goodWeInverterCurrentDataDto.getSn());
					jpInverterElectricity.setThirdCode(PVProducerInfoEnum.GDW.getCode());
					jpInverterElectricity.setThirdStationId(jpInverter.getThirdStationId());
					jpInverterElectricity.setType("直流");
					jpInverterElectricity.setName("PV" + k1);
					jpInverterElectricity.setVoltage(Double.valueOf(hanlderResult.get("vpv" + k1).toString()));
					jpInverterElectricity.setCurrent(Double.valueOf(hanlderResult.get("ipv" + k1).toString()));
//                    jpInverterElectricity.setPower(Double.valueOf(hanlderResult.get("pow" + k1).toString()));
					if (org.springframework.util.ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
						jpInverterElectricityMapper.insert(jpInverterElectricity);
					} else {
						jpInverterElectricityMapper.updateById(jpInverterElectricity);
					}
				}
				HYGFJPInverterElecHistory hygfjpInverterElecHistory = new HYGFJPInverterElecHistory();
				hygfjpInverterElecHistory.setThirdStationId(jpInverter.getThirdStationId());
				hygfjpInverterElecHistory.setCreatedTime(System.currentTimeMillis());
				hygfjpInverterElecHistory.setSnCode(goodWeInverterCurrentDataDto.getSn());
				hygfjpInverterElecHistory.setUAcCurrent(goodWeInverterCurrentDataDto.getD().getIac1());
				hygfjpInverterElecHistory.setVAcCurrent(goodWeInverterCurrentDataDto.getD().getIac2());
				hygfjpInverterElecHistory.setWAcCurrent(goodWeInverterCurrentDataDto.getD().getIac3());
				hygfjpInverterElecHistory.setUAcVoltage(goodWeInverterCurrentDataDto.getD().getVac1());
				hygfjpInverterElecHistory.setVAcVoltage(goodWeInverterCurrentDataDto.getD().getVac2());
				hygfjpInverterElecHistory.setWAcVoltage(goodWeInverterCurrentDataDto.getD().getVac3());
				hygfjpInverterElecHistory.setThirdCode(PVProducerInfoEnum.GDW.getCode());
				hygfjpInverterElecHistory.setTime(System.currentTimeMillis());
				hygfjpInverterElecHistoryMapper.insert(hygfjpInverterElecHistory);
				// 逆变器历史
				String today = DateUtil.today();
				HYGFJPInverterHistory hygfjpInverterHistory = hygfjpInverterHistoryMapper
						.selectOne(new QueryWrapper<HYGFJPInverterHistory>()
								.eq("sn_code", goodWeInverterCurrentDataDto.getSn()).eq("date", today));
				if (org.springframework.util.ObjectUtils.isEmpty(hygfjpInverterHistory)) {
					hygfjpInverterHistory = new HYGFJPInverterHistory();
				}
				hygfjpInverterHistory.setDate(today);
				hygfjpInverterHistory.setThirdStationId(jpInverter.getThirdStationId());
				hygfjpInverterHistory.setInverterId(jpInverter.getId());
				hygfjpInverterHistory.setSnCode(goodWeInverterCurrentDataDto.getSn());
				hygfjpInverterHistory.setThirdCode(PVProducerInfoEnum.GDW.getCode());
				if (ObjectUtils.isNotEmpty(jpInverter.getCapacity())
						&& ObjectUtils.isNotEmpty(jpInverter.getDayPowerGeneration())) {
					hygfjpInverterHistory
							.setGenerationHours(jpInverter.getDayPowerGeneration() / jpInverter.getCapacity());
				}

				hygfjpInverterHistory.setPowerGeneration(goodWeInverterCurrentDataDto.getEday());
				if (org.springframework.util.ObjectUtils.isEmpty(hygfjpInverterHistory.getCreatedTime())) {
					hygfjpInverterHistory.setCreatedTime(System.currentTimeMillis());
					hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
				} else {
					hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
				}
				// -----------------------户用光伏日报表----------------------
				TdHYGFInverterDayGenerate tdHYGFInverterDayGenerate = new TdHYGFInverterDayGenerate();
				tdHYGFInverterDayGenerate.setCreatedTime(System.currentTimeMillis());
				tdHYGFInverterDayGenerate.setName(jpInverter.getName());
				tdHYGFInverterDayGenerate.setThirdStationId(String.valueOf(jpInverter.getThirdStationId()));
				tdHYGFInverterDayGenerate.setSnCode(jpInverter.getSnCode().trim());
				tdHYGFInverterDayGenerate.setWorkStatus(jpInverter.getState());
				D d = goodWeInverterCurrentDataDto.getD();
				// 交流电压
				tdHYGFInverterDayGenerate.setDcv1(d.getVac1());
				tdHYGFInverterDayGenerate.setDcv2(d.getVac2());
				tdHYGFInverterDayGenerate.setDcv3(d.getVac3());
				// 交流电流
//                tdHYGFInverterDayGenerate.setDcv4(inverterDetailDto.getUAc4());
				tdHYGFInverterDayGenerate.setDcc1(d.getIac1());
				tdHYGFInverterDayGenerate.setDcc2(d.getIac2());
				tdHYGFInverterDayGenerate.setDcc3(d.getIac3());
//                tdHYGFInverterDayGenerate.setDcc4(inverterDetailDto.getIAc4());
				// 直流电压
				tdHYGFInverterDayGenerate.setAcv1(d.getVpv1());
				tdHYGFInverterDayGenerate.setAcv2(d.getVpv2());
				tdHYGFInverterDayGenerate.setAcv3(d.getVpv3());
				tdHYGFInverterDayGenerate.setAcv4(d.getVpv4());
				// 直流电流
				tdHYGFInverterDayGenerate.setAcc1(d.getIpv1());
				tdHYGFInverterDayGenerate.setAcc2(d.getIpv2());
				tdHYGFInverterDayGenerate.setAcc3(d.getIpv3());
				tdHYGFInverterDayGenerate.setAcc4(d.getIpv4());
				// 功率
//                tdHYGFInverterDayGenerate.setPv1(inverterDetailDto.getPow1());
//                tdHYGFInverterDayGenerate.setPv2(inverterDetailDto.getPow2());
//                tdHYGFInverterDayGenerate.setPv3(inverterDetailDto.getPow3());
//                tdHYGFInverterDayGenerate.setPv4(inverterDetailDto.getPow4());

//                tdHYGFInverterDayGenerate.setTotalPower(inverterDetailDto.getPac());
//                tdHYGFInverterDayGenerate.setFrequency(String.valueOf(inverterDetailDto.getFac()));
//                tdHYGFInverterDayGenerate.setPowerFactor(inverterDetailDto.getPowerFactor());
				tdHYGFInverterDayGenerate.setDayGen(jpInverter.getDayPowerGeneration());

				tdHYGFInverterDayGenerate.setMonthGen(jpInverter.getMonthPowerGeneration());
				tdHYGFInverterDayGenerate.setYearGen(jpInverter.getYearPowerGeneration());
				tdHYGFInverterDayGenerate.setTotalGen(jpInverter.getTotalPowerGeneration());
				tdHYGFInverterDayGenerate.setIgbtTemp(goodWeInverterCurrentDataDto.getTempperature());
				tdHYGFInverterDayGenerate.setIncome(null);
				if (ObjectUtils.isNotEmpty(jpInverter.getCapacity())
						&& ObjectUtils.isNotEmpty(jpInverter.getDayPowerGeneration())) {
					tdHYGFInverterDayGenerate
							.setFullhour(jpInverter.getDayPowerGeneration() / jpInverter.getCapacity());
				}

				// 电站区域经销商，
				JpStation jpStation = jpStationMapper
						.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.GDW.getCode())
								.eq("third_station_id", String.valueOf(jpInverter.getThirdStationId())));

				if (jpStation != null) {
					tdHYGFInverterDayGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					tdHYGFInverterDayGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					tdHYGFInverterDayGenerate.setStationName(jpStation.getName());
					tdHYGFInverterDayGenerate.setStationState(jpStation.getState());

				}

				tdHYGFInverterDayGenerateMapper.insert(tdHYGFInverterDayGenerate);
				// 户用场站月发电量
				Date today1 = new Date();
				TdHYGFInverterMonthGenerate tdHYGFInverterMonthGenerate = tdHYGFInverterMonthGenerateMapper
						.selectOne(new QueryWrapper<TdHYGFInverterMonthGenerate>()
								.eq("third_station_id", jpInverter.getThirdStationId())
								.eq("sn_code", jpInverter.getSnCode())
								.eq("day_time", DateUtil.format(today1, "yyyy-MM-dd"))
								.eq("year_month", DateUtil.format(today1, "yyyy-MM")));
				if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterMonthGenerate)) {
					tdHYGFInverterMonthGenerate = new TdHYGFInverterMonthGenerate();
				}
				tdHYGFInverterMonthGenerate.setThirdStationId(jpInverter.getThirdStationId());
				tdHYGFInverterMonthGenerate.setSnCode(jpInverter.getSnCode().trim());
				tdHYGFInverterMonthGenerate.setName(jpInverter.getName());
				tdHYGFInverterMonthGenerate.setDayTime(DateUtil.format(today1, "yyyy-MM-dd"));
				tdHYGFInverterMonthGenerate.setYearMonth(DateUtil.format(today1, "yyyy-MM"));
				tdHYGFInverterMonthGenerate.setGenerate(jpInverter.getDayPowerGeneration());

				// 新加
				if (jpStation != null) {
					tdHYGFInverterMonthGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					tdHYGFInverterMonthGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					tdHYGFInverterMonthGenerate.setStationName(jpStation.getName());
					tdHYGFInverterMonthGenerate.setStationState(jpStation.getState());

				}

				if (ObjectUtils.isNotEmpty(jpInverter.getCapacity())
						&& ObjectUtils.isNotEmpty(jpInverter.getDayPowerGeneration())) {
					tdHYGFInverterMonthGenerate
							.setFullhour(jpInverter.getDayPowerGeneration() / jpInverter.getCapacity());
				}

				if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterMonthGenerate.getCreatedTime())) {
					tdHYGFInverterMonthGenerate.setCreatedTime(System.currentTimeMillis());
					tdHYGFInverterMonthGenerateMapper.insert(tdHYGFInverterMonthGenerate);
				} else {
					tdHYGFInverterMonthGenerateMapper.insert(tdHYGFInverterMonthGenerate);
				}
				// 户用场站年发电量
				TdHYGFInverterYearGenerate tdHYGFInverterYearGenerate = tdHYGFInverterYearGenerateMapper
						.selectOne(new QueryWrapper<TdHYGFInverterYearGenerate>()
								.eq("third_station_id", jpInverter.getThirdStationId())
								.eq("sn_code", jpInverter.getSnCode())
								.eq("month_time", DateUtil.format(today1, "yyyy-MM"))
								.eq("year", DateUtil.format(today1, "yyyy")));
				if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterYearGenerate)) {
					tdHYGFInverterYearGenerate = new TdHYGFInverterYearGenerate();
				}
				tdHYGFInverterYearGenerate.setThirdStationId(jpInverter.getThirdStationId());
				tdHYGFInverterYearGenerate.setSnCode(jpInverter.getSnCode().trim());
				tdHYGFInverterYearGenerate.setMonthTime(DateUtil.format(today1, "yyyy-MM"));
				tdHYGFInverterYearGenerate.setYear(DateUtil.format(today1, "yyyy"));
				tdHYGFInverterYearGenerate.setGenerate(jpInverter.getMonthPowerGeneration());
				if (ObjectUtils.isNotEmpty(jpInverter.getCapacity())
						&& ObjectUtils.isNotEmpty(jpInverter.getMonthPowerGeneration())) {
					tdHYGFInverterYearGenerate
							.setFullhour(jpInverter.getMonthPowerGeneration() / jpInverter.getCapacity());
				}
				tdHYGFInverterYearGenerate.setName(jpInverter.getName());

				// 新加
				if (jpStation != null) {
					tdHYGFInverterYearGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					tdHYGFInverterYearGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					tdHYGFInverterYearGenerate.setStationName(jpStation.getName());
					tdHYGFInverterYearGenerate.setStationState(jpStation.getState());

				}

				if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterYearGenerate.getCreatedTime())) {
					tdHYGFInverterYearGenerate.setCreatedTime(System.currentTimeMillis());
					tdHYGFInverterYearGenerateMapper.insert(tdHYGFInverterYearGenerate);
				} else {
					tdHYGFInverterYearGenerateMapper.insert(tdHYGFInverterYearGenerate);
				}
				// 户用场站年发电量
				TdHYGFInverterTotalGenerate tdHYGFInverterTotalGenerate = tdHYGFInverterTotalGenerateMapper
						.selectOne(new QueryWrapper<TdHYGFInverterTotalGenerate>()
								.eq("third_station_id", jpInverter.getThirdStationId())
								.eq("sn_code", jpInverter.getSnCode()).eq("year_time", DateUtil.format(today1, "yyyy"))
								.eq("year", DateUtil.format(today1, "yyyy")));
				if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterTotalGenerate)) {
					tdHYGFInverterTotalGenerate = new TdHYGFInverterTotalGenerate();
				}
				tdHYGFInverterTotalGenerate.setThirdStationId(jpInverter.getThirdStationId());
				tdHYGFInverterTotalGenerate.setName(null == jpInverter.getName() ? null : jpInverter.getName());
				tdHYGFInverterTotalGenerate.setSnCode(jpInverter.getSnCode().trim());
				tdHYGFInverterTotalGenerate.setYearTime(DateUtil.format(today1, "yyyy"));
				tdHYGFInverterTotalGenerate.setYear(DateUtil.format(today1, "yyyy"));
				tdHYGFInverterTotalGenerate.setGenerate(jpInverter.getYearPowerGeneration());
				if (ObjectUtils.isNotEmpty(jpInverter.getCapacity())
						&& ObjectUtils.isNotEmpty(jpInverter.getYearPowerGeneration())) {
					tdHYGFInverterTotalGenerate
							.setFullhour(jpInverter.getYearPowerGeneration() / jpInverter.getCapacity());
				}
				// 新加
				if (jpStation != null) {
					tdHYGFInverterTotalGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					tdHYGFInverterTotalGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					tdHYGFInverterTotalGenerate.setStationName(jpStation.getName());
					tdHYGFInverterTotalGenerate.setStationState(jpStation.getState());

				}
				if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterTotalGenerate.getCreatedTime())) {
					tdHYGFInverterTotalGenerate.setCreatedTime(System.currentTimeMillis());
					tdHYGFInverterTotalGenerateMapper.insert(tdHYGFInverterTotalGenerate);
				} else {
					tdHYGFInverterTotalGenerateMapper.insert(tdHYGFInverterTotalGenerate);
				}
			});

		}
		logger.info("-------固德威同步逆变器详情结束" + ts + "------- " + sdf.format(new Date()));
	}

	@Override
	@Scheduled(cron = "${dataRequstScheduled.GoodWe}")
	@Async
	public void inverterMonthGen() {
		long ts = System.currentTimeMillis();
		logger.info("-------固德威同步逆变器月发电量开始" + ts + "------- " + sdf.format(new Date()));
		List<String> sns = jpInverterMapper.getGoodWeSnCodes();
		String currentMonth = DateUtil.format(new Date(), "yyyyMM");
		sns.forEach(sn -> {
			HashMap<String, Object> requestInfo = new HashMap<>();
			requestInfo.put("sn", sn);
			requestInfo.put("date", DateUtil.today());
			requestInfo.put("count", 0);
			requestInfo.put("type", 1);
			String requstParam = JSON.toJSONString(requestInfo);
			String apiUrl = GoodWeConstant.getinverterGenURl + "?sn=" + sn + "&date=" + DateUtil.today()
					+ "&count=0&type=1";
			List<GoodWEGenStation> goodWEGenStations = goodWeRequestUtil.getResPonse(apiUrl, GoodWeConstant.requestGet,
					requstParam, GoodWeConstant.resovleRule_data, GoodWEGenStation.class);
			List<GoodWEGenStation> currentMonthGenStations = goodWEGenStations.stream()
					.filter(goodWEGenStation -> goodWEGenStation.getDate().equals(currentMonth))
					.collect(Collectors.toList());
			currentMonthGenStations.forEach(goodWEGenStation -> {
				JpInverter jpInverter = jpInverterMapper.selectOne(new QueryWrapper<JpInverter>()
						.eq("third_code", PVProducerInfoEnum.GDW.getCode()).eq("sn_code", sn));
				if (ObjectUtils.isNotEmpty(jpInverter)) {
					jpInverter.setMonthPowerGeneration(Double.parseDouble(goodWEGenStation.getPower()));
					jpInverterMapper.updateById(jpInverter);
				}
			});
		});
		logger.info("-------固德威同步逆变器月发电量结束" + ts + "------- " + sdf.format(new Date()));
	}

	@Override
	@Scheduled(cron = "${dataRequstScheduled.GoodWe}")
	@Async
	public void inverterYearGen() {
		long ts = System.currentTimeMillis();
		logger.info("-------固德威同步逆变器年发电量开始" + ts + "------- " + sdf.format(new Date()));
		String currentYear = DateUtil.format(new Date(), "yyyy");
		List<String> sns = jpInverterMapper.getGoodWeSnCodes();
		sns.forEach(sn -> {
			HashMap<String, Object> requestInfo = new HashMap<>();
			requestInfo.put("sn", sn);
			requestInfo.put("date", DateUtil.today());
			requestInfo.put("count", 0);
			requestInfo.put("type", 2);
			String requstParam = JSON.toJSONString(requestInfo);
			String apiUrl = GoodWeConstant.getinverterGenURl + "?sn=" + sn + "&date=" + DateUtil.today()
					+ "&count=0&type=2";
			List<GoodWEGenStation> goodWEGenStations = goodWeRequestUtil.getResPonse(apiUrl, GoodWeConstant.requestGet,
					requstParam, GoodWeConstant.resovleRule_data, GoodWEGenStation.class);
			List<GoodWEGenStation> currentMonthGenStations = goodWEGenStations.stream()
					.filter(goodWEGenStation -> goodWEGenStation.getDate().equals(currentYear))
					.collect(Collectors.toList());
			currentMonthGenStations.forEach(goodWEGenStation -> {
				JpInverter jpInverter = jpInverterMapper.selectOne(new QueryWrapper<JpInverter>()
						.eq("third_code", PVProducerInfoEnum.GDW.getCode()).eq("sn_code", sn));
				if (ObjectUtils.isNotEmpty(jpInverter)) {
					jpInverter.setYearPowerGeneration(Double.parseDouble(goodWEGenStation.getPower()));
					jpInverterMapper.updateById(jpInverter);
				}
			});
		});
		logger.info("-------固德威同步逆变器年发电量结束" + ts + "------- " + sdf.format(new Date()));
	}

	@Override
	public void inverAlramInfo(String stationid) {
		HashMap<String, Object> requestInfo = new HashMap<>();
		String today = DateUtil.today();
		requestInfo.put("page_index", 1);
		requestInfo.put("page_size", 1000);
		requestInfo.put("starttime", today + " 00:00:00");
		requestInfo.put("endtime", today + " 23:59:59");
		requestInfo.put("stationid", stationid);
//        requestInfo.put("status", 2);
		String requstParam = JSON.toJSONString(requestInfo);
		List<GoodWeAlarmDto> alarmList = goodWeRequestUtil.getResPonse(GoodWeConstant.alarmListUrl,
				GoodWeConstant.requestPost, requstParam, GoodWeConstant.resovleRule_data_list, GoodWeAlarmDto.class);
		alarmList.forEach(goodWeAlarmDto -> {
			if (!ObjectUtils.isEmpty(goodWeAlarmDto.getDevicesn())) {
				HYGFJPInverterWarn hygfjpInverterWarn = hygfjpInverterWarnMapper
						.selectOne(new QueryWrapper<HYGFJPInverterWarn>().eq("sn_code", goodWeAlarmDto.getDevicesn())
								.eq("start_time", goodWeAlarmDto.getHappentime().getMillis())
								.eq("third_station_id", String.valueOf(goodWeAlarmDto.getStationId())));
				if (ObjectUtils.isEmpty(hygfjpInverterWarn)) {
					hygfjpInverterWarn = new HYGFJPInverterWarn();
				}
				hygfjpInverterWarn.setTime(System.currentTimeMillis());
				hygfjpInverterWarn.setSnCode(goodWeAlarmDto.getDevicesn());
				hygfjpInverterWarn.setThirdStationId(goodWeAlarmDto.getStationId());
//                hygfjpInverterWarn.setLevel(GoLangConstant.alarmLevel.get(alarmDto.getAlarmLevel()));
				hygfjpInverterWarn.setContent(goodWeAlarmDto.getWarningname());
				hygfjpInverterWarn.setThirdCode(PVProducerInfoEnum.GDW.getCode());
				if (GoodWeConstant.errorCodeMap.get(goodWeAlarmDto.getError_code()) != null) {
					hygfjpInverterWarn
							.setTreatment(GoodWeConstant.errorCodeMap.get(goodWeAlarmDto.getError_code()).get(2));
				}
				hygfjpInverterWarn.setStartTime(goodWeAlarmDto.getHappentime().getMillis());

				// 电站区域经销商，
				JpStation jpStation = jpStationMapper
						.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.GDW.getCode())
								.eq("third_station_id", String.valueOf(goodWeAlarmDto.getStationId())));

				if (jpStation != null) {
					hygfjpInverterWarn.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					hygfjpInverterWarn.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					hygfjpInverterWarn.setStationName(jpStation.getName());
					hygfjpInverterWarn.setStationState(jpStation.getState());

				}

				hygfjpInverterWarn.setRecoverTime(null);
				if (!ObjectUtils.isEmpty(goodWeAlarmDto.getRecoverytime())) {
					hygfjpInverterWarn.setRecoverTime(goodWeAlarmDto.getRecoverytime().getMillis());
				}
				hygfjpInverterWarn.setTimeLong(null);
				if ((!ObjectUtils.isEmpty(goodWeAlarmDto.getHappentime()))
						&& (!ObjectUtils.isEmpty(goodWeAlarmDto.getRecoverytime()))) {
					hygfjpInverterWarn.setTimeLong(
							goodWeAlarmDto.getRecoverytime().getMillis() - goodWeAlarmDto.getHappentime().getMillis());
				}
				hygfjpInverterWarn.setState(GoodWeConstant.warningStaus.get(goodWeAlarmDto.getStatus().toString()));
				if (org.springframework.util.ObjectUtils.isEmpty(hygfjpInverterWarn.getCreatedTime())) {
					hygfjpInverterWarn.setCreatedTime(System.currentTimeMillis());
					hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
				} else {
					hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
				}
			}
		});
	}
}
