package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.FireTeam;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* 消防队伍 Mapper 接口
*
* @author tb
* @date 2021-06-07
*/
public interface FireTeamMapper extends BaseMapper<FireTeam> {


	/**
	 * 返回监控大队信息列表
	 *
	 * @return
	 */
	List<FireBrigadeResourceDto> listMonitorFireBrigade(@Param("code") String code );

	/**
	 * 查询消防队伍卡片分页列表
	 *
	 * @param page
	 * @param par
	 * @return
	 */
	IPage<FireTeamCardDto> getFireTeamForPage(Page<FireTeamCardDto> page, FireTeamListDto par);


	/**
	 * 根据队伍id查询队伍下人员列表
	 *
	 * @param teamIds
	 * @return
	 */
	List<FirefightersDto> queryFighterByTeamId(@Param("teamIds") List<String> teamIds);

	/**
	 * 根据当前队伍id查询该队伍下所有子队伍
	 *
	 * @param teamId
	 * @return
	 */
	List<FireTeam> listFireTeamById(Long teamId);



	/***
	 *
	 *  指挥队伍资源 列表
	 *
	 * **/
	List<FireTeamZhDto> getFireTeamList(@Param("pageNum")int pageNum, @Param("pageSize")int pageSize, @Param("par") RequestData par);

	/***
	 *
	 *  指挥队伍资源 统计
	 *
	 * **/
	Integer getFireTeamListCount(@Param("par")RequestData par);





	List<FireTeamZhDto> getFireTeamCountList();


	/**
	 * 根据teamId 返回队伍底下人员数量
	 * @param teamId
	 * @return
	 */
	Integer getFighterNumByTeamId(Long teamId);

	/**
	 * 根据companyCode 返回机构下所有的队伍
	 * @param teamId
	 * @return
	 */
	List<FireTeam> byTeamId(Long teamId);

	List<FireTeamDto> listFireTeamDto(Boolean isDelete, String nodeId, String nodeType, String name, String typeCode,List<String> nodeIds, String bizOrgCode);

	List<FireTeamDto> listFireTeamDtoTree(Boolean isDelete);


}
