package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireDangerDayStatisticsDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireDangerDayStatistics;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireDangerDayStatisticsMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireDangerDayStatisticsService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 换流站隐患日统计服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireDangerDayStatisticsServiceImpl extends BaseService<FireDangerDayStatisticsDto, FireDangerDayStatistics, FireDangerDayStatisticsMapper> implements IFireDangerDayStatisticsService {

    /**
     * 列表查询 示例
     */
    public List<FireDangerDayStatisticsDto> queryForFireDangerDayStatisticsList() {
        return this.queryForList("", false);
    }

    public int createDangerTimesCount(String stationCode, String beginDate, String endDate) {
        LambdaQueryWrapper<FireDangerDayStatistics> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(StringUtils.isNotBlank(stationCode),FireDangerDayStatistics::getStationCode, stationCode);
        wrapper.ge(FireDangerDayStatistics::getCollectDate, beginDate);
        wrapper.le(FireDangerDayStatistics::getCollectDate, endDate);
        List<FireDangerDayStatistics> list = this.list(wrapper);
        return list.stream().mapToInt(FireDangerDayStatistics::getDangerTimes).sum();
    }

    public List<String> dangerTimesTrend(String stationCode, String beginDate, String endDate) {
        return this.baseMapper.queryDangerTimesTrend(stationCode,beginDate,endDate);
    }
}