package com.yeejoin.amos.boot.module.hygf.api.dto;



import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.util.Date;
import java.util.List;

/**
 * (hygf_icbc_record)实体类
 *
 * @author yangyang
 * @description
 * @since 2024-07-18 11:40:46
 */
@Data
@NoArgsConstructor
@ApiModel (value = "HygfIcbcRecordDTO", description = "聚富通钱包开户DTO")
public class HygfIcbcRecordDTO  {

    private static final long serialVersionUID = 1L;

    protected Long sequenceNbr;

    @ApiModelProperty (value = "农户姓名")
    private String custName;
    /**
     * 身份证号
     */
    @ApiModelProperty (value = "身份证号")
    private String idCard;
    /**
     * 手机号码
     */
    @ApiModelProperty (value = "手机号码")
    private String phone;
    /**
     * 聚富通电子账户账号
     */
    @ApiModelProperty (value = "聚富通电子账户账")
    private String mediumId;
    /**
     * 项目编号
     */
    @ApiModelProperty (value = "项目编号")
    private String projectId;
    /**
     * 开户状态, 00-初始，01-开户中，02-开户成功，03-开户失败
     */
    @ApiModelProperty (value = "开户状态, 00-初始，01-开户中，02-开户成功，03-开户失败")
    private String openAccountStatus;

    @ApiModelProperty (value = "开户状态Name")
    private String openAccountStatusName;
    /**
     * 协议状态, 0-未生效，1-已生效，2-过期，3-作废，4-待短信确认
     */
    @ApiModelProperty (value = "协议状态, 0-未生效，1-已生效，2-过期，3-作废，4-待短信确认")
    private String protocolStatus;

    @ApiModelProperty (value = "协议状态Name")
    private String protocolStatusName;
    /**
     * 协议开始日期
     */
    @ApiModelProperty (value = "协议开始日期")
    private String protocolStartTime;
    /**
     * 协议终止日期
     */
    @ApiModelProperty (value = "协议终止日期")
    private String protocolEndTime;
    /**
     * 单笔限额
     */
    @ApiModelProperty (value = "单笔限额")
    private String trxLimitAmount;
    /**
     * 日累计限额
     */
    @ApiModelProperty (value = "日累计限额")
    private String dayLimitAmount;
    /**
     * 协议总限额
     */
    @ApiModelProperty (value = "协议总限额")
    private String protocolLimitAmount;
    /**
     * 合作方 appid
     */
    @ApiModelProperty (value = "合作方 appid")
    private String appId;
    /**
     * 外部用户编号
     */
    @ApiModelProperty (value = "外部用户编号")
    private String outUserId;
    /**
     * 企业外系统编号
     */
    @ApiModelProperty (value = "企业外系统编号")
    private String outVendorId;
    /**
     * signEntrsutPrtlStatus
     */
    @ApiModelProperty (value = "signEntrsutPrtlStatus")
    private String signEntrsutPrtlStatus;
    /**
     * 作废申请状态
     */
    @ApiModelProperty (value = "作废申请状态")
    private String discardStatus;

    @ApiModelProperty(value = "农户id")
    private String amosUserId;

    @ApiModelProperty(value = "电站信息")
    private List<IcbcPeasantHousehold> peasantHouseholds;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class IcbcPeasantHousehold {
        /**
         * 农户信息编号
         */
        @ApiModelProperty(value = "农户信息编号")
        private String peasantHouseholdNo;
        /**
         * 项目地址
         */
        @ApiModelProperty(value = "项目地址")
        private List<Integer> projectAddress;
        /**
         * 项目地址
         */
        @ApiModelProperty(value = "项目地址")
        private String projectAddressName;
        /*
         * 区域公司id
         * */
        @ApiModelProperty(value = "区域公司id")
        private Long regionalCompaniesSeq;
        /*
         * 区域公司code
         * */
        @ApiModelProperty(value = "区域公司code")
        private String regionalCompaniesCode;
        /*
         * 区域公司名称
         * */
        @ApiModelProperty(value = "区域公司名称")
        private String regionalCompaniesName;
    }

}