package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 农户信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_peasant_household",autoResultMap = true)
public class PeasantHousehold extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
     * 勘察表id
     */
    @TableField("survey_information_id")
    private Long surveyInformationId;
    /**
     * 农户信息编号
     */
	@TableField("peasant_household_no")
    private String peasantHouseholdNo;

    /**
     * 业主姓名
     */
	@TableField("owners_name")
    private String ownersName;

    /**
     * 联系电话
     */
	@TableField("telephone")
    private String telephone;

    /**
     * 开发方名称
     */
	@TableField("developer_name")
    private String developerName;

    /**
     * 开发方code
     */
	@TableField("developer_code")
    private String developerCode;

    @TableField("developer_id")
    private Long developerId;
    /**
     * 定金
     */
	@TableField("deposit")
    private Float deposit;

    /**
     * 创建时间
     */
	@TableField("creation_time")
    private Date creationTime;

    /**
     * 项目地址
     */
	@TableField(value = "project_address",typeHandler = FastjsonTypeHandler.class)
    private List<Integer> projectAddress;

    /**
     * 常住地址
     */
	@TableField(value = "permanent_address",typeHandler = FastjsonTypeHandler.class)
    private List<Integer> permanentAddress;

    /**
     * 常住地址
     */
    @TableField("permanent_address_name")
    private String permanentAddressName;

    /**
     * 项目地址
     */
    @TableField("project_address_name")
    private String projectAddressName;

    /**
     * 是否勘察 0,1
     */
	@TableField("survey_or_not")
    private Integer surveyOrNot;

    /**
     * 身份证号
     */
	@TableField("id_card")
    private String idCard;

    /**
     * 邮箱
     */
	@TableField("mailbox")
    private String mailbox;

    /**
     *  审核状态 0未审核,1审核中，2审核结束
     */
	@TableField("review")
    private Integer review;

    /**
     * 项目详细地址
     */
	@TableField("project_address_detail")
    private String projectAddressDetail;

    /**
     * 常住详细地址
     */
	@TableField("permanent_address_detail")
    private String permanentAddressDetail;

	/*
	* 开发人
	* */
    @TableField("developer")
    private String developer;

    @TableField("developer_user_id")
    private String developerUserId;
    /*
     * 区域公司id
     * */
    @TableField("regional_companies_seq")
    private Long regionalCompaniesSeq;
    /*
     * 区域公司code
     * */
    @TableField("regional_companies_code")
    private String regionalCompaniesCode;
    /*
     * 区域公司名称
     * */
    @TableField("regional_companies_name")
    private String regionalCompaniesName;
    /*
     * 身份证正面
     * */
    @TableField(value = "id_card_front", typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardFront;
    /*
     * 身份证反面
     * */
    @TableField(value = "id_card_opposite", typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardOpposite;
    /*
     * 微信唯一id
     * */
    @TableField("open_id")
    private String openId;
    /*
     * 是否已认证（0-未认证，1-已认证）
     * */
    @TableField("is_certified")
    private Integer isCertified;
    /*
     * 平台userId
     * */
    @TableField("amos_user_id")
    private String amosUserId;

    @TableField(exist = false)
    protected Long stationId;

    /**施工状态**/

    /**
     *  已发货，已收货，
     */
    @TableField("preparation_money_state")
    private String preparationMoneyState;

    /**
     *  备货状态
     */
    @TableField("construction_state")
    private String constructionState;

    @TableField(exist = false)
    private String surveyOrNotText;

    @TableField(exist = false,typeHandler = FastjsonTypeHandler.class)
    private List<String> permanentAddressText;

    @TableField(exist = false,typeHandler = FastjsonTypeHandler.class)
    private List<String> projectAddressText;

    /**
     * 当前农户下所有的合同是否已废弃, 1(全部已废弃), 0(未全部废弃)
     */
    @TableField(exist = false)
    private Integer isAllRevoke;
}
