package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.ContractTemplateDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.ContractTemplate;
import com.yeejoin.amos.boot.module.hygf.api.entity.HouseholdContract;
import com.yeejoin.amos.boot.module.hygf.api.mapper.ContractTemplateMapper;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.ContractTemplateServiceImpl;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.HouseholdContractServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 
 *
 * @author system_generator
 * @date 2023-08-22
 */
@RestController
@Api(tags = "合同模板Api")
@RequestMapping(value = "/contract-template")
public class ContractTemplateController extends BaseController {

    @Autowired
    ContractTemplateServiceImpl contractTemplateServiceImpl;
    @Autowired
    HouseholdContractServiceImpl householdContractServiceImpl;
    @Autowired
    ContractTemplateMapper contractTemplateMapper;
    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<ContractTemplateDto> save(@RequestBody ContractTemplateDto model) {
	    model = contractTemplateServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<ContractTemplateDto> updateBySequenceNbrContractTemplate(@RequestBody ContractTemplateDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(contractTemplateServiceImpl.updateWithModel(model));
	}
    /**
     * 列表全部数据查询
     *
     * @returnhousehold-contract
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
    @GetMapping(value = "/list/{id}")
    public ResponseModel<List<ContractTemplate>> selectForList(@PathVariable String id) {
        HouseholdContract householdContract = householdContractServiceImpl.getById(id);
        LambdaQueryWrapper<ContractTemplate> up=new LambdaQueryWrapper();
        up.eq(ContractTemplate::getAmosCompanySeq,householdContract.getRegionalCompaniesSeq());
        List<ContractTemplate>  dat= contractTemplateMapper.selectList(up);
        return ResponseHelper.buildResponse(dat);
    }
	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(contractTemplateServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
//	@TycloudOperation(ApiLevel = UserType.AGENCY)
//	@GetMapping(value = "/{sequenceNbr}")
//	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
//	public ResponseModel<ContractTemplateDto> selectOne(@PathVariable Long sequenceNbr) {
//	    return ResponseHelper.buildResponse(contractTemplateServiceImpl.queryBySeq(sequenceNbr));
//	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<ContractTemplateDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<ContractTemplateDto> page = new Page<ContractTemplateDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(contractTemplateServiceImpl.queryForContractTemplatePage(page));
	}


}
