package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.icbc.api.response.JftApiUserEntrustopenacctQueryResponseV1;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingRectificationOrderDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.HouseholdContractDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfIcbcRecordDTO;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfIcbcRecordQueryDTO;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.HygfIcbcServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.List;


/**
 * 并网信息
 */




@RestController
@Api(tags = "电子钱包")
@RequestMapping(value = "/icbc")
public class HygfIcbcController extends BaseController {

    @Autowired
    HygfIcbcServiceImpl hygfIcbcService;


    /**
     * 注册电子钱包
     * @param req
     * @param resp
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/icbcRegisterWalletUrl")
    @ApiOperation(httpMethod = "GET",value = "注册电子钱包",  notes = "注册电子钱包")
    public void getHygfIcbcRegisterWalletUrl(HttpServletRequest req, HttpServletResponse resp) {
         hygfIcbcService.icbcRegisterWalletUrl(req, resp);
    }

    /**
     * 从工行获取电子钱包信息
     * @param req
     * @param resp
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getHygfIcbcWalletInfo")
    @ApiOperation(httpMethod = "GET",value = "获取钱包信息",  notes = "获取钱包信息")
    public ResponseModel<JftApiUserEntrustopenacctQueryResponseV1> getHygfIcbcWalletInfo(HttpServletRequest req, HttpServletResponse resp) {
        return ResponseHelper.buildResponse(hygfIcbcService.getHygfIcbcWalletInfo(req.getParameter("userId")));
    }

    /**
     * 开户签约异步通知
     *
     *
     * @param request request
     * @param response response
     * @return {@link  Object}
     * @author yangyang
     * @throws
     * @date 2024/7/18 19:39
     */
    @TycloudOperation (ApiLevel = UserType.PUBLIC, needAuth = false)
    @PostMapping (value = "/notify")
    @ApiOperation (httpMethod = "POST", value = "注册电子钱包回调", notes = "注册电子钱包回调")
    public Object notify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return hygfIcbcService.registerWalletCallback(request, response);
    }

    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/{userId}")
    @ApiOperation (httpMethod = "GET", value = "根据农户userId查询注册电子钱包", notes = "注册电子钱包")
    public ResponseModel<HygfIcbcRecordDTO> getObject(@PathVariable String userId) {
        return ResponseHelper.buildResponse(hygfIcbcService.getObject(userId));
    }

    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/getWalletInfo/{userId}")
    @ApiOperation (httpMethod = "GET", value = "根据农户userId查询注册电子钱包", notes = "注册电子钱包")
    public ResponseModel<JftApiUserEntrustopenacctQueryResponseV1> getHygfIcbcWalletInfo(@PathVariable String userId) {
        return ResponseHelper.buildResponse(hygfIcbcService.getHygfIcbcWalletInfo(userId));
    }

    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/list")
    @ApiOperation (httpMethod = "GET", value = "聚富通电子钱包列表查询", notes = "聚富通电子钱包列表查询")
    @UserLimits
    public ResponseModel<List<HygfIcbcRecordDTO>> listObject(@ApiParam HygfIcbcRecordQueryDTO hygfIcbcRecordQueryDTO) {
        return ResponseHelper.buildResponse(hygfIcbcService.listObject(hygfIcbcRecordQueryDTO));
    }

    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/page")
    @ApiOperation (httpMethod = "GET", value = "聚富通电子钱包分页查询", notes = "聚富通电子钱包分页查询")
    @UserLimits
    public ResponseModel<Page<HygfIcbcRecordDTO>> queryForPage(@ApiParam HygfIcbcRecordQueryDTO hygfIcbcRecordQueryDTO) {

        return ResponseHelper.buildResponse(hygfIcbcService.queryForPage(hygfIcbcRecordQueryDTO.getCurrent(), hygfIcbcRecordQueryDTO.getSize(), hygfIcbcRecordQueryDTO));
    }

}
