package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.hygf.api.Enum.RectificationOrderEnum;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfRectificationOrder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.HygfRectificationOrderServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfRectificationOrderDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 审核单
 *
 * @author system_generator
 * @date 2024-08-12
 */
@RestController
@Api(tags = "审核单Api")
@RequestMapping(value = "/hygf-rectification-order")
public class HygfRectificationOrderController extends BaseController {

    @Autowired
    HygfRectificationOrderServiceImpl hygfRectificationOrderServiceImpl;
	@Value("${admin.engineering.roleId}")
	Long engineeringId;
	@Value("${admin.area.roleId}")
	Long areaId;
	@Value("${admin.design.roleId}")
	Long designId;
	@Value("${admin.deveEngineering.roleId}")
	Long deveEngineeringId;
    /**
     * 新增审核单
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增审核单", notes = "新增审核单")
	public ResponseModel<HygfRectificationOrderDto> save(@RequestBody HygfRectificationOrderDto model) {
	    model = hygfRectificationOrderServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新审核单", notes = "根据sequenceNbr更新审核单")
	public ResponseModel<HygfRectificationOrderDto> updateBySequenceNbrHygfRectificationOrder(@RequestBody HygfRectificationOrderDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(hygfRectificationOrderServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除审核单", notes = "根据sequenceNbr删除审核单")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(hygfRectificationOrderServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个审核单",  notes = "根据sequenceNbr查询单个审核单")
	public ResponseModel<HygfRectificationOrder> selectOne(@PathVariable Long sequenceNbr) {

	    return ResponseHelper.buildResponse(hygfRectificationOrderServiceImpl.getBaseMapper().selectById(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "审核单分页查询",  notes = "审核单分页查询")
	public ResponseModel<Page<HygfRectificationOrder>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
                    (value = "size") int size, @RequestParam(value = "rectificationSource",required = false) String rectificationSource, @RequestParam(value = "peasantHouseholeId") String peasantHouseholeId) {

		ReginParams reginParams = getSelectedOrgInfo();
		List<String> workOrderPowerStationNodes = new ArrayList<>();
//		workOrderPowerStationNodes.add(rectificationSource);
		for (Long aLong : reginParams.getUserModel().getOrgRoleSeqs().keySet()) {
			List<Long> longs = reginParams.getUserModel().getOrgRoleSeqs().get(aLong);
			if (longs.contains(areaId) ) {
				workOrderPowerStationNodes.add("area");
			}
			if (longs.contains(engineeringId) ) {
				workOrderPowerStationNodes.add("engineering");
			}
			if (longs.contains(designId) ) {
				workOrderPowerStationNodes.add("design");
			}
		}

		Page<HygfRectificationOrder> page = hygfRectificationOrderServiceImpl.queryForHygfRectificationOrderPage(current, size, workOrderPowerStationNodes, peasantHouseholeId);
		for (Long aLong : reginParams.getUserModel().getOrgRoleSeqs().keySet()) {
			List<Long> longs = reginParams.getUserModel().getOrgRoleSeqs().get(aLong);
				page.getRecords().forEach(e->{
					if (longs.contains(areaId) && e.getRectificationSource().equals("area")){
						e.setIsAudit("0");
					}else if (longs.contains(engineeringId) && e.getRectificationSource().equals("engineering")){
						e.setIsAudit("0");
					}else if (longs.contains(designId) && e.getRectificationSource().equals("design")){
						e.setIsAudit("0");
					}else if (longs.contains(engineeringId)){
						e.setIsAudit("0");
					}else {
						e.setIsAudit("1");
					}
				});
		}

	    return ResponseHelper.buildResponse(page);
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "审核单列表全部数据查询",   notes = "审核单列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<HygfRectificationOrder>> selectForList(@RequestParam(value = "peasantHouseholeId") String peasantHouseholeId,@RequestParam(value = "sourceType") String sourceType) {

		return ResponseHelper.buildResponse(hygfRectificationOrderServiceImpl.selectForListBySource(peasantHouseholeId,sourceType));
	}
}
