package com.yeejoin.amos.boot.module.hygf.biz.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.hygf.api.entity.UnitInfo;
import com.yeejoin.amos.boot.module.hygf.api.mapper.PersonnelBusinessMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.UnitInfoMapper;
import com.yeejoin.amos.boot.module.hygf.api.util.CommonResponseNewUtil;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.PeasantHouseholdServiceImpl;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.SurveyInformationServiceImpl;
import com.yeejoin.amos.boot.module.standard.api.entity.PublicAgencyUser;
import com.yeejoin.amos.boot.module.standard.api.mapper.PublicAgencyUserMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.util.AesUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 农户信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@RestController
@Api(tags = "农户信息Api")
@RequestMapping(value = "/test")
public class TestController extends BaseController {

	@Autowired
	SurveyInformationServiceImpl surveyInformationServiceImpl;

	@Autowired
	PeasantHouseholdServiceImpl peasantHouseholdServiceImpl;

	@Autowired
	RedisUtils redisUtils;

	private static final String regionRedis = "app_region_redis";
	@Autowired
	PersonnelBusinessMapper personnelBusinessMapper;

	@Autowired
	UnitInfoMapper unitInfoMapper;

	@Autowired
	PublicAgencyUserMapper publicAgencyUserMapper;

	/**
	 * 新增农户信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/initpw")
	@ApiOperation(httpMethod = "GET", value = "新增农户信息", notes = "新增农户信息")
	public ResponseModel<Object> initpw() {
		// 经销商管理员
		List<UnitInfo> list = unitInfoMapper.selectList(null);
		for (UnitInfo unitInfo : list) {
			try {
				int ph = unitInfo.getAdminPhone().length();
				String npwd = "Zxnk_" + unitInfo.getAdminPhone().substring(ph - 4, ph);
				String npwdm = AesUtil.encode(npwd, "qaz");
				unitInfo.setAdminLoginPwd(npwdm);
				FeignClientResult<AgencyUserModel> re = Privilege.agencyUserClient
						.queryByUserId(unitInfo.getAdminUserId());
				AgencyUserModel ag = re.getResult();
				ag.setPassword(AesUtil.encode(npwd, "qaz"));
				ag.setRePassword(AesUtil.encode(npwd, "qaz"));
				Privilege.agencyUserClient.restorePassword(unitInfo.getAdminUserId());
				ag.setOriginalPassword(AesUtil.encode("Z2%Op9.q", "qaz"));
				Privilege.agencyUserClient.modifyPassword(unitInfo.getAdminUserId(), ag);
				unitInfoMapper.updateById(unitInfo);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		// 经销商子人员
		List<PublicAgencyUser> list2 = publicAgencyUserMapper.selectList(null);
		for (PublicAgencyUser unitInfo : list2) {
			try {
				int ph = unitInfo.getEmergencyTelephone().length();
				String npwd = "Zxnk_" + unitInfo.getEmergencyTelephone().substring(ph - 4, ph);
				String npwdm = AesUtil.encode(npwd, "qaz");
				unitInfo.setPassword(npwdm);
				FeignClientResult<AgencyUserModel> re = Privilege.agencyUserClient
						.queryByUserId(unitInfo.getAmosUserId());
				AgencyUserModel ag = re.getResult();
				ag.setPassword(AesUtil.encode(npwd, "qaz"));
				ag.setRePassword(AesUtil.encode(npwd, "qaz"));
				Privilege.agencyUserClient.restorePassword(unitInfo.getAmosUserId());
				ag.setOriginalPassword(AesUtil.encode("Z2%Op9.q", "qaz"));
				Privilege.agencyUserClient.modifyPassword(unitInfo.getAmosUserId(), ag);
				publicAgencyUserMapper.updateById(unitInfo);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return CommonResponseNewUtil.success();
	}
}