package com.yeejoin.amos.boot.module.jxiop.biz.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TimeRangeUtil {

//	public static void main(String[] args) throws ParseException {
//		LocalDate start = LocalDate.of(2024, 7, 5);
//		LocalDate end = LocalDate.of(2024, 7, 9);
//		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//		Date date = sdf.parse("2024-07-05");
//		Date date2 = sdf.parse("2024-07-09");
//		//getDateInfo(date, date2);
//		//getHourInfo(date, date2);
//		//getMomentInfo(date, date2);
//	}

	public static List<String> getDateInfoBy15() {
		List<String> list = new ArrayList<String>();

		LocalDate today = LocalDate.now().minusDays(1); // 获取今天的日期
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

		for (int i = 0; i < 15; i++) {
			LocalDate previousDay = today.minusDays(i);
			String formattedDate = previousDay.format(formatter);
			list.add(formattedDate);
		}

		return list;
	}

	public static List<String> getDateInfo(Date startTime, Date endTime) {
		List<String> list = new ArrayList<String>();
		List<LocalDate> dates = new ArrayList<>();
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

		LocalDate startInclusive = LocalDate.parse(sdf.format(startTime));
		LocalDate endExclusive = LocalDate.parse(sdf.format(endTime));

		while (!startInclusive.isAfter(endExclusive.minusDays(0))) {
			dates.add(startInclusive);
			String formattedDate = startInclusive.format(formatter);
			list.add(formattedDate);
			startInclusive = startInclusive.plusDays(1);
		}

		return list;
	}

	public static List<String> getHourInfo(Date startTime, Date endTime) {
		List<String> list = new ArrayList<String>();
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		LocalDateTime startInclusive = LocalDateTime.parse(sdf.format(startTime),formatter);
		LocalDateTime endExclusive = LocalDateTime.parse(sdf.format(endTime),formatter);

		List<LocalDateTime> hourlyList = new ArrayList<>();
		LocalDateTime currentDateTime = startInclusive;

		// 当前时间小于或等于结束时间
		while (currentDateTime.isBefore(endExclusive.plusDays(1)) || currentDateTime.isEqual(endExclusive)) {
			// 仅在开始和结束时间范围内添加每小时
			if (currentDateTime.isAfter(startInclusive.minusSeconds(1))
					&& currentDateTime.isBefore(endExclusive.plusSeconds(1))) {
				hourlyList.add(currentDateTime.withMinute(0).withSecond(0).withNano(0)); // 移除分钟、秒和纳秒
				list.add(formatter.format(currentDateTime));
			}
			// 移动到下一个小时
			currentDateTime = currentDateTime.plus(1, ChronoUnit.HOURS);
		}

		return list;
	}

	public static List<String> getMomentInfo(Date startTime, Date endTime) {
		List<String> list = new ArrayList<String>();
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		LocalDateTime startInclusive = LocalDateTime.parse(sdf.format(startTime),formatter);
		LocalDateTime endExclusive = LocalDateTime.parse(sdf.format(endTime),formatter);

		List<LocalDateTime> hourlyList = new ArrayList<>();
		LocalDateTime currentDateTime = startInclusive;

		// 当前时间小于或等于结束时间
		while (currentDateTime.isBefore(endExclusive.plusDays(1)) || currentDateTime.isEqual(endExclusive)) {
			// 仅在开始和结束时间范围内添加每小时
			if (currentDateTime.isAfter(startInclusive.minusSeconds(1))
					&& currentDateTime.isBefore(endExclusive.plusSeconds(1))) {
				hourlyList.add(currentDateTime.withMinute(0).withSecond(0).withNano(0)); // 移除分钟、秒和纳秒
				list.add(formatter.format(currentDateTime));
			}
			// 移动到下一个小时
			currentDateTime = currentDateTime.plus(10, ChronoUnit.MINUTES);
		}
		
		for(String s: list) 
		{
			System.out.println(s);
		}

		return list;
	}
}
