package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.RoleNameExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 值班班次
 *
 * @author system_generator
 * @date 2021-07-06
 */
@Data
@ApiModel(value = "DutyPersonDto", description = "值班人")
public class DutyPersonExcelDto implements Serializable {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "序号", index = 0)
    @ApiModelProperty(value = "序号")
    private Integer number;

    @ExcelProperty(value = "用户ID", index = 1)
    @ApiModelProperty(value = "用户id")
    private String userId;

    @ExcelProperty(value = "姓名", index = 2)
    @ApiModelProperty(value = "用户名称")
    private String userName;

    @ExcelIgnore
    @ApiModelProperty(value = "部门id")
    private String deptId;

    @ExcelProperty(value = "单位/部门", index = 3)
    @ApiModelProperty(value = "部门名称")
    private String deptName;

    @ExcelIgnore
    @ApiModelProperty(value = "岗位id")
    private String postType;

    @ExplicitConstraint(type = "DUTY_POST_TYPE", indexNum = 4, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "岗位", index = 4)
    @ApiModelProperty(value = "岗位名称")
    private String postTypeName;
}
