package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
/**
* 消防队伍
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_fire_team")
@ApiModel(value="FireTeam对象", description="消防队伍")
public class FireTeam extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "消防队伍图片")
    private String img;

    @ApiModelProperty(value = "单位名称")
    private String name;
    
    @ApiModelProperty(value = "父级")
    private Long parent;

    @ApiModelProperty(value = "所属机构")
    private Long company;

    @ApiModelProperty(value = "机构code")
    private String companyCode;

    @ApiModelProperty(value = "联系人id")
    private Long contactUserId;

    @ApiModelProperty(value = "联系人")
    private String contactUser;

    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    @ApiModelProperty(value = "职责_简要情况")
    private String obligation;

    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    private Double latitude;
    
    @ApiModelProperty(value = "队伍地址")
    private String address;
    
    @ApiModelProperty(value = "机构名称")
    private String companyName;
    @ApiModelProperty(value = "队伍类型")
    private String type;
    @ApiModelProperty(value = "队伍code")
    private String typeCode;
   
    @ApiModelProperty(value = "更新时间")
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    @ApiModelProperty(value = "树结构层级code")
    private String treeCode;
}
