package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
/**
* 消防队员
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_firefighters")
@ApiModel(value="Firefighters对象", description="消防队员")
public class Firefighters extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "系统账号")
    private String systemAccount;

    @ApiModelProperty(value = "员工编码")
    private String employeeNumber;

    @ApiModelProperty(value = "所属机构")
    private String company;

    @ApiModelProperty(value = "机构code")
    private String companyCode;

    @ApiModelProperty(value = "队伍id")
    private Long fireTeamId;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "常用证件类型代码")
    private String certificatesType;

    @ApiModelProperty(value = "常用证件类型代码code")
    private String certificatesTypeCode;


    @ApiModelProperty(value = "证件号码")
    private String certificateNumber;

    @ApiModelProperty(value = "出生日期")
    private Date birthdayTime;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "民族")
    private String nation;

    @ApiModelProperty(value = "籍贯/户口所在地")
    private String nativePlace;

    @ApiModelProperty(value = "现居住地")
    private String residence;

    @ApiModelProperty(value = "现居住地详情")
    private String residenceDetails;

    @ApiModelProperty(value = "机场住宿情况")
    private String airportAccommodation;

    @ApiModelProperty(value = "岗位名称")
    private String jobTitle;

    
    @ApiModelProperty(value = "岗位名称数据字典code")
    private String jobTitleCode;
    
    @ApiModelProperty(value = "人员状态，在职/离职")
    private String state;
    @ApiModelProperty(value = "人员状态，在职/离职字典code")
    private String stateCode;

    @ApiModelProperty(value = "婚姻状况")
    private String maritalStatus;

    @ApiModelProperty(value = "办公电话")
    private String officeTelephone;

    @ApiModelProperty(value = "手机")
    private String mobilePhone;

    @ApiModelProperty(value = "互联网_电子信箱")
    private String email;

    @ApiModelProperty(value = "政治面貌代码")
    private String politicalOutlook;

    @ApiModelProperty(value = "人员照片")
    private String personnelPhotos;

    @ApiModelProperty(value = "身份证正面")
    private String idPositive;

    @ApiModelProperty(value = "身份证反面")
    private String idReverse;

    @ApiModelProperty(value = "更新时间")
    @TableField(fill=FieldFill.UPDATE)
    private Date updateTime;

    @ApiModelProperty(value = "机构名称")
    private String companyName;
}
