package com.yeejoin.amos.maintenance.common.enums;

public enum LatentDangerOvertimeStateEnum {
    未超时("未超时", 0),
    已超时("已超时", 1);

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    LatentDangerOvertimeStateEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static LatentDangerOvertimeStateEnum getByCode(Integer code) {
        for (LatentDangerOvertimeStateEnum l : LatentDangerOvertimeStateEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }
}
