package com.yeejoin.amos.patrol.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * The persistent class for the p_point_classify database table.
 *
 */
@Entity
@Table(name="p_point_classify")
@NamedQuery(name="PointClassify.findAll", query="SELECT p FROM PointClassify p")
public class PointClassify extends BasicEntity{
	private static final long serialVersionUID = 1L;

	/**
	 * 创建人id
	 */
	@Column(name="creator_id")
	private String creatorId;

	/**
	 * 点分类名称
	 */
	private String name;

	/**
	 * 排序号
	 */
	@Column(name="order_no")
	private int orderNo;

	/**
	 * 点id
	 */
	@Column(name="point_id")
	private long pointId;

	/**
	 * 原始字段
	 */
	@Column(name = "original_id", columnDefinition = "varchar(50) COMMENT '原始字段'")
	private String originalId;

	/**
	 * 装备id
	 */
	@Column(name="equipment_id")
	private String equipmentId;

	/**
	 * 巡查规范名称
	 */
	@Column(name="inspection_spec_name")
	private String inspectionSpecName;

	public String getEquipmentId() {
		return equipmentId;
	}

	public void setEquipmentId(String equipmentId) {
		this.equipmentId = equipmentId;
	}

	public String getInspectionSpecName() {
		return inspectionSpecName;
	}

	public void setInspectionSpecName(String inspectionSpecName) {
		this.inspectionSpecName = inspectionSpecName;
	}


	public PointClassify() {
	}

	public String getCreatorId() {
		return this.creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getOrderNo() {
		return this.orderNo;
	}

	public void setOrderNo(int orderNo) {
		this.orderNo = orderNo;
	}

	public long getPointId() {
		return this.pointId;
	}

	public void setPointId(long pointId) {
		this.pointId = pointId;
	}

	public String getOriginalId() {
		return originalId;
	}

	public void setOriginalId(String originalId) {
		this.originalId = originalId;
	}
}