package com.yeejoin.amos.api.householdapi.exception;

import org.apache.commons.lang3.StringUtils;
import org.typroject.tyboot.core.foundation.exception.BaseException;

/**
 * 自定义异常
 *
 * @author yangyang
 * @version v1.0
 * @date 2023/9/19 12:37
 */
public class BusinessException extends BaseException {

    private String code;

    public BusinessException(String message) {
        super(message, BusinessException.class.getSimpleName(), "错误的请求.");
        this.code = "-1";
        this.httpStatus = 500;
    }

    public BusinessException(String errorCode, String message) {
        super(message, BusinessException.class.getSimpleName(), message);
        if (StringUtils.isBlank(errorCode)) {
            this.httpStatus = 500;
            this.code = errorCode;
        } else {
            this.httpStatus = Integer.parseInt(errorCode);
            this.code = errorCode;
        }
    }

    public boolean isTokenError() {
        return "401".equals(this.code);
    }

}
