package com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.models.auth.In;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 户用光伏监盘逆变器电能表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@Accessors(chain = true)
@TableName("hygf_jp_inverter_electricity")
public class JpInverterElectricity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    @TableField(value = "rec_date", fill = FieldFill.INSERT_UPDATE)
    protected Date recDate;

    @TableField(value = "rec_user_id", fill = FieldFill.INSERT_UPDATE)
    protected String recUserId;

    @TableField(value = "rec_user_name", fill = FieldFill.INSERT_UPDATE)
    protected String recUserName;

    /**
     * 是否删除
     */
    @TableField(value = "is_delete")
    public Boolean isDelete=false;
    /**
     * 逆变器id
     */
	@TableField("inverter_id")
    private String inverterId;

    /**
     * sn编码
     */
	@TableField("sn_code")
    private String snCode;

    /**
     * 电能名称
     */
	@TableField("name")
    private String name;

    /**
     * 电能类型(直流/交流)
     */
	@TableField("type")
    private String type;

    /**
     * 电压
     */
	@TableField("voltage")
    private Double voltage;

    /**
     * 电流
     */
	@TableField("current")
    private Double current;

    /**
     * 功率
     */
	@TableField("power")
    private Double power;

    /**
     * 频率
     */
	@TableField("frequency")
    private Double frequency;

    /**
     * 第三方电站id
     */
	@TableField("third_station_id")
    private String thirdStationId;

    /**
     * 第三方厂商标识
     */
	@TableField("third_code")
    private String thirdCode;
}
